/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation.transformers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import oracle.bpm.extensionpoint.metadata.XMLModelTransformerMetadata;
import oracle.bpm.log.Log;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.DOMTransformer;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@XMLModelTransformerMetadata
public class XMLModelTransformer20101105
extends DOMTransformer {
    @Override
    public Integer getToVersion() {
        return 20101105;
    }

    @Override
    protected void transform(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        this.fixDefaultSize(document, xPath);
        this.fixRelativeCoordinates(document, xPath);
    }

    @Override
    protected Map<String, String> getCurrentVersionNamespacesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("bpmn", "http://www.omg.org/bpmn20");
        result.put("bpmnext", "http://xmlns.oracle.com/bpm/OracleExtensions");
        return result;
    }

    private void fixDefaultSize(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Default size conversion...");
        String expression = "//bpmnext:Size[@width='21' and @height='21']";
        List<Element> elements = this.getElements(document, xPath, expression);
        for (Element element : elements) {
            element.getParentNode().removeChild(element);
        }
    }

    private void fixRelativeCoordinates(@NotNull XMLDocument document, @NotNull XPath xPath) throws Exception {
        Log.logDebug((String)"Relative coordinates conversion...");
        String expression = "//bpmn:process/bpmnext:OracleExtensions/bpmnext:FeatureSet";
        Element featureSetElement = this.getElement(document, xPath, expression);
        if (featureSetElement != null) {
            Element relativeFeature = document.createElementNS(xPath.getNamespaceContext().getNamespaceURI("bpmnext"), "BooleanFeature");
            relativeFeature.setAttribute("value", "false");
            relativeFeature.setAttribute("name", "relative-coordinates");
            featureSetElement.appendChild(relativeFeature);
        }
    }
}

