/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.transformation;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.AbstractXMLModelTransformer;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.InputOutputStream;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.TransformationException;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.XMLModelTransformer;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DOMTransformer
extends AbstractXMLModelTransformer
implements XMLModelTransformer {
    @Override
    public void transform(@NotNull InputOutputStream ioStream) throws TransformationException {
        try {
            DOMParser parser = new DOMParser();
            parser.parse(ioStream.getInputStream());
            XMLDocument document = parser.getDocument();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NamespaceContext context = this.createBPMNNamespaceContext();
            xPath.setNamespaceContext(context);
            this.transform(document, xPath);
            ioStream.reset();
            document.print((OutputStream)ioStream);
        }
        catch (Throwable e) {
            throw TransformationException.createInvalidModel(e);
        }
    }

    protected abstract Map<String, String> getCurrentVersionNamespacesMap();

    protected abstract void transform(@NotNull XMLDocument var1, @NotNull XPath var2) throws Exception;

    protected List<Element> getElements(@NotNull XMLDocument document, @NotNull XPath xPath, @NotNull String expression) throws XPathExpressionException {
        return this.getElements((Object)document, xPath, expression);
    }

    protected List<Element> getChildrenElements(@NotNull Element element) {
        return this.toElementList(element.getChildNodes());
    }

    protected void clearChildrenElements(@NotNull Element element) {
        List<Element> childrenElements = this.getChildrenElements(element);
        for (Element childElement : childrenElements) {
            element.removeChild(childElement);
        }
    }

    protected Element getElement(@NotNull XMLDocument document, @NotNull XPath xPath, @NotNull String expression) throws XPathExpressionException {
        return this.getElement((Object)document, xPath, expression);
    }

    protected Element getElement(@NotNull Node element, @NotNull XPath xPath, @NotNull String expression) throws XPathExpressionException {
        return this.getElement((Object)element, xPath, expression);
    }

    protected boolean replaceAttribute(@NotNull XMLDocument document, @NotNull Element element, @NotNull String oldAttributeName, @NotNull String newAttributeName) {
        if (element.hasAttribute(oldAttributeName)) {
            String oldValue = element.getAttribute(oldAttributeName);
            Attr newAttribute = document.createAttribute(newAttributeName);
            newAttribute.setValue(oldValue);
            NamedNodeMap attributes = element.getAttributes();
            attributes.setNamedItem(newAttribute);
            attributes.removeNamedItem(oldAttributeName);
            return true;
        }
        return false;
    }

    private List<Element> toElementList(@NotNull NodeList nodeList) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            result.add((Element)node);
        }
        return result;
    }

    private List<Element> getElements(@NotNull Object object, @NotNull XPath xPath, @NotNull String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPath.evaluate(expression, object, XPathConstants.NODESET);
        return this.toElementList(nodeList);
    }

    private Element getElement(@NotNull Object object, @NotNull XPath xPath, @NotNull String expression) throws XPathExpressionException {
        Element result = null;
        Node node = (Node)xPath.evaluate(expression, object, XPathConstants.NODE);
        if (node instanceof Element) {
            result = (Element)node;
        }
        return result;
    }

    private NamespaceContext createBPMNNamespaceContext() {
        BPMNNamespaceContext result = new BPMNNamespaceContext();
        Map<String, String> namespacesMap = this.getCurrentVersionNamespacesMap();
        for (String prefix : namespacesMap.keySet()) {
            result.addNamespace(prefix, namespacesMap.get(prefix));
        }
        return result;
    }

    private static class BPMNNamespaceContext
    implements NamespaceContext {
        BiMap<String, String> namespaces = new HashBiMap();

        private BPMNNamespaceContext() {
        }

        public void addNamespace(@NotNull String prefix, @NotNull String uri) {
            this.namespaces.put((Object)prefix, (Object)uri);
        }

        @Override
        public String getNamespaceURI(String s) {
            return (String)this.namespaces.get((Object)s);
        }

        @Override
        public String getPrefix(String s) {
            return (String)this.namespaces.inverse().get((Object)s);
        }

        public Iterator getPrefixes(String s) {
            return this.namespaces.keySet().iterator();
        }
    }
}

