/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model.bpmn.normalization.normalizers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.extensionpoint.metadata.JAXBModelNormalizerMetadata;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.io.bpmn.jaxb.ObjectFactory;
import oracle.bpm.project.io.bpmn.jaxb.TBaseElement;
import oracle.bpm.project.io.bpmn.jaxb.TCatchEvent;
import oracle.bpm.project.io.bpmn.jaxb.TDefinitions;
import oracle.bpm.project.io.bpmn.jaxb.TEndEvent;
import oracle.bpm.project.io.bpmn.jaxb.TErrorEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TEvent;
import oracle.bpm.project.io.bpmn.jaxb.TEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TExtensionElements;
import oracle.bpm.project.io.bpmn.jaxb.TFlowElement;
import oracle.bpm.project.io.bpmn.jaxb.TFlowNode;
import oracle.bpm.project.io.bpmn.jaxb.TMessageEventDefinition;
import oracle.bpm.project.io.bpmn.jaxb.TProcess;
import oracle.bpm.project.io.bpmn.jaxb.TReceiveTask;
import oracle.bpm.project.io.bpmn.jaxb.TRootElement;
import oracle.bpm.project.io.bpmn.jaxb.TSendTask;
import oracle.bpm.project.io.bpmn.jaxb.TServiceTask;
import oracle.bpm.project.io.bpmn.jaxb.TStartEvent;
import oracle.bpm.project.io.bpmn.jaxb.TSubProcess;
import oracle.bpm.project.io.bpmn.jaxb.TThrowEvent;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TBooleanFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversation;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversational;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversationalError;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TConversations;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDefineInterfaceConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TDefineInterfaceConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TFeatureSet;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TOracleExtensions;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TProcessCallConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TProcessCallConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TServiceCallConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TServiceCallConversationalDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TStringFeature;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TTypeRef;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TUseInterfaceConversationDefinition;
import oracle.bpm.project.io.bpmn.jaxb.extensions.TUseInterfaceConversationalDefinition;
import oracle.bpm.project.io.serializers.model.bpmn.IoUtils;
import oracle.bpm.project.io.serializers.model.bpmn.normalization.AbstractJAXBModelNormalizer;
import oracle.bpm.project.io.serializers.model.bpmn.normalization.NormalizationException;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import org.jetbrains.annotations.NotNull;

@JAXBModelNormalizerMetadata
public class JAXBModelNormalizer20110501
extends AbstractJAXBModelNormalizer {
    @Override
    public void normalize(@NotNull JAXBElement element) throws NormalizationException {
        StatefulJAXBModelNormalizer20110501 statefulNormalizer = new StatefulJAXBModelNormalizer20110501();
        statefulNormalizer.normalize(element);
    }

    @Override
    public Integer getToVersion() {
        return 20110501;
    }

    private static class StatefulJAXBModelNormalizer20110501 {
        private TConversation definitionConversation;
        private oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory extensionsFactory = new oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory();
        private ObjectFactory objectFactory = new ObjectFactory();
        private Map<String, TConversation> processCallConversations = new HashMap<String, TConversation>();
        private Map<String, TFlowNode> processConversationalNodes = new HashMap<String, TFlowNode>();
        private Map<String, TConversation> serviceCallConversations = new HashMap<String, TConversation>();
        private Map<String, TFlowNode> subprocessesConversationalNodes = new HashMap<String, TFlowNode>();
        private TProcess tProcess;
        private Set<String> usedConversationIds = new HashSet<String>();
        private Map<String, TConversation> useReferenceConversations = new HashMap<String, TConversation>();

        private StatefulJAXBModelNormalizer20110501() {
        }

        public void normalize(@NotNull JAXBElement element) throws NormalizationException {
            Object value = element.getValue();
            if (value != null && value instanceof TDefinitions) {
                TDefinitions definitions = (TDefinitions)value;
                List<JAXBElement<? extends TRootElement>> rootElements = definitions.getRootElement();
                for (JAXBElement<? extends TRootElement> rootElement : rootElements) {
                    TRootElement tRootElement = (TRootElement)rootElement.getValue();
                    if (!(tRootElement instanceof TProcess)) continue;
                    this.tProcess = (TProcess)tRootElement;
                    this.normalize();
                }
            }
        }

        private void addProcessConversation(@NotNull TConversation tConversation) {
            TOracleExtensions processExtensions = this.getOrCreateOracleExtensionsFor(this.tProcess);
            TConversations tConversations = processExtensions.getConversations();
            if (tConversations == null) {
                tConversations = this.extensionsFactory.createTConversations();
                processExtensions.setConversations(tConversations);
            }
            List<TConversation> conversationsList = tConversations.getConversation();
            conversationsList.add(tConversation);
        }

        private void normalize() {
            List<JAXBElement<? extends TFlowElement>> processElements = this.tProcess.getFlowElement();
            this.loadConversationalNodes(processElements, false);
            for (TFlowNode tFlowNode : this.getAllConversationals()) {
                this.handleConversationalFlowNode(tFlowNode);
            }
            if (!this.hasInboundConversations()) {
                this.setupDefaultConversation();
            }
            if (this.definitionConversation != null) {
                this.addProcessConversation(this.definitionConversation);
            }
            for (TConversation tConversation : this.useReferenceConversations.values()) {
                this.addProcessConversation(tConversation);
            }
            for (TConversation tConversation : this.serviceCallConversations.values()) {
                this.addProcessConversation(tConversation);
            }
            for (TConversation tConversation : this.processCallConversations.values()) {
                this.addProcessConversation(tConversation);
            }
        }

        private void setupDefaultConversation() {
            TStartEvent start = null;
            TEndEvent end = null;
            for (TFlowNode tFlowNode : this.processConversationalNodes.values()) {
                TEndEvent possibleEnd;
                if (tFlowNode instanceof TStartEvent) {
                    TStartEvent possibleStart = (TStartEvent)tFlowNode;
                    if (this.getMessageEventDefinition(possibleStart) != null) {
                        start = possibleStart;
                    }
                } else if (tFlowNode instanceof TEndEvent && this.getMessageEventDefinition(possibleEnd = (TEndEvent)tFlowNode) != null) {
                    end = possibleEnd;
                }
                if (start == null || end == null) continue;
                break;
            }
            if (start != null) {
                TConversation conversation = this.getOrCreateDefinitionConversation();
                TConversational startConversational = this.getOrCreateConversationalExtension(start);
                startConversational.setConversation(conversation.getId());
                TDefineInterfaceConversationalDefinition startDefinition = this.extensionsFactory.createTDefineInterfaceConversationalDefinition();
                startConversational.setDefineInterfaceConversationalDefinition(startDefinition);
                startDefinition.setDefinedOperationName("operation");
                if (end != null) {
                    TConversational endConversational = this.getOrCreateConversationalExtension(end);
                    endConversational.setConversation(conversation.getId());
                    TDefineInterfaceConversationalDefinition endDefinition = this.extensionsFactory.createTDefineInterfaceConversationalDefinition();
                    endConversational.setDefineInterfaceConversationalDefinition(endDefinition);
                    endDefinition.setDefinedOperationName("operationCallback");
                }
            }
        }

        private TConversational getOrCreateConversationalExtension(@NotNull TFlowNode tFlowNode) {
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFlowNode);
            TConversational tConversational = tOracleExtensions.getConversational();
            if (tConversational == null) {
                tConversational = this.extensionsFactory.createTConversational();
                tOracleExtensions.setConversational(tConversational);
            }
            return tConversational;
        }

        private boolean hasInboundConversations() {
            return this.definitionConversation != null || !this.useReferenceConversations.values().isEmpty();
        }

        private void handleConversationalFlowNode(@NotNull TFlowNode tFlowNode) {
            if (this.isDefinitionConversation(tFlowNode) || this.isMessageWithError(tFlowNode)) {
                this.handleDefinitionFlowNode(tFlowNode);
            } else if (this.isServiceConversation(tFlowNode)) {
                this.handleServiceFlowNode(tFlowNode);
            } else if (this.isProcessConversation(tFlowNode)) {
                this.handleProcessCallFlowNode(tFlowNode);
            }
        }

        private void handleDefinitionFlowNode(@NotNull TFlowNode tFlowNode) {
            TFlowNode initiator = this.getInitiator(tFlowNode);
            if (initiator == null || this.isDefinitionConversation(initiator)) {
                Tuple<String, Boolean> initiatorDefinedOperationAndSync;
                Boolean isSync;
                TConversational tConversational = this.getOrCreateConversationalExtension(tFlowNode);
                TConversation tConversation = this.getOrCreateDefinitionConversation();
                tConversational.setConversation(tConversation.getId());
                TDefineInterfaceConversationalDefinition definition = this.extensionsFactory.createTDefineInterfaceConversationalDefinition();
                tConversational.setDefineInterfaceConversationalDefinition(definition);
                if (initiator != null && this.isSender(tFlowNode) && (isSync = (Boolean)(initiatorDefinedOperationAndSync = this.getDefinedOperationAndSync(initiator)).getSecond()).booleanValue()) {
                    definition.setReplyTo(initiator.getId());
                    Tuple<String, TTypeRef> associatedError = this.getMessageEventAssociatedError(tFlowNode);
                    if (associatedError != null) {
                        TConversationalError tConversationalError = this.extensionsFactory.createTConversationalError();
                        tConversationalError.setErrorName((String)associatedError.getFirst());
                        tConversationalError.setTypeRef((TTypeRef)associatedError.getSecond());
                        definition.setConversationalError(tConversationalError);
                    }
                }
                if (definition.getReplyTo() == null) {
                    Tuple<String, Boolean> definedOperationAndSync = this.getDefinedOperationAndSync(tFlowNode);
                    String operationName = (String)definedOperationAndSync.getFirst();
                    definition.setDefinedOperationName(operationName);
                }
            }
        }

        private void handleServiceFlowNode(@NotNull TFlowNode tFlowNode) {
            Tuple<String, String> serviceAndOperation = this.getServiceAndOperation(tFlowNode);
            TFlowNode initiator = this.getInitiator(tFlowNode);
            String service = null;
            if (initiator != null) {
                if (this.isServiceConversation(initiator)) {
                    Tuple<String, String> initiatorServiceAndOperation = this.getServiceAndOperation(initiator);
                    service = (String)initiatorServiceAndOperation.getFirst();
                }
            } else {
                service = (String)serviceAndOperation.getFirst();
            }
            if (service != null) {
                boolean isServiceCall = initiator == null && !this.isReceiver(tFlowNode) || initiator != null && !this.isReceiver(initiator);
                String operation = (String)serviceAndOperation.getSecond();
                TConversational tConversational = this.getOrCreateConversationalExtension(tFlowNode);
                if (isServiceCall) {
                    TConversation tConversation = this.getOrCreateServiceCallConversation(service);
                    tConversational.setConversation(tConversation.getId());
                    TServiceCallConversationalDefinition definition = this.extensionsFactory.createTServiceCallConversationalDefinition();
                    tConversational.setServiceCallConversationalDefinition(definition);
                    definition.setOperation(operation);
                } else {
                    TConversation tConversation = this.getOrCreateUseReferenceConversation(service);
                    tConversational.setConversation(tConversation.getId());
                    TUseInterfaceConversationalDefinition definition = this.extensionsFactory.createTUseInterfaceConversationalDefinition();
                    tConversational.setUseInterfaceConversationalDefinition(definition);
                    definition.setOperation(operation);
                }
            }
        }

        private void handleProcessCallFlowNode(@NotNull TFlowNode tFlowNode) {
            Tuple<String, String> associatedProcessAndNode = this.getAssociatedProcessAndNode(tFlowNode);
            String process = (String)associatedProcessAndNode.getFirst();
            String node = (String)associatedProcessAndNode.getSecond();
            TConversational tConversational = this.getOrCreateConversationalExtension(tFlowNode);
            TConversation tConversation = this.getOrCreateProcessCallConversation(process);
            tConversational.setConversation(tConversation.getId());
            TProcessCallConversationalDefinition definition = this.extensionsFactory.createTProcessCallConversationalDefinition();
            tConversational.setProcessCallConversationalDefinition(definition);
            definition.setTargetConversational(node);
        }

        private void loadConversationalNodes(@NotNull List<JAXBElement<? extends TFlowElement>> elements, boolean isSubprocess) {
            for (JAXBElement<? extends TFlowElement> jaxbElement : elements) {
                TFlowElement tFlowElement = (TFlowElement)jaxbElement.getValue();
                if (tFlowElement == null || !(tFlowElement instanceof TFlowNode)) continue;
                TFlowNode tFlowNode = (TFlowNode)tFlowElement;
                if (this.isConversationalNode(tFlowNode)) {
                    if (isSubprocess) {
                        this.subprocessesConversationalNodes.put(tFlowNode.getId(), tFlowNode);
                        continue;
                    }
                    this.processConversationalNodes.put(tFlowNode.getId(), tFlowNode);
                    continue;
                }
                if (!(tFlowNode instanceof TSubProcess)) continue;
                TSubProcess tSubProcess = (TSubProcess)tFlowNode;
                List<JAXBElement<? extends TFlowElement>> subprocessElements = tSubProcess.getFlowElement();
                this.loadConversationalNodes(subprocessElements, true);
            }
        }

        private boolean isConversationalNode(@NotNull TFlowNode tFlowNode) {
            return tFlowNode instanceof TEvent && this.getMessageEventDefinition((TEvent)tFlowNode) != null || tFlowNode instanceof TSendTask || tFlowNode instanceof TReceiveTask || tFlowNode instanceof TServiceTask && this.getStringFeature(tFlowNode, "updateTargetType") == null && this.getStringFeature(tFlowNode, "notificationType") == null;
        }

        private boolean isSender(@NotNull TFlowNode tFlowNode) {
            return tFlowNode instanceof TThrowEvent || tFlowNode instanceof TSendTask;
        }

        private boolean isReceiver(@NotNull TFlowNode tFlowNode) {
            return tFlowNode instanceof TCatchEvent || tFlowNode instanceof TReceiveTask;
        }

        private boolean isProcessConversation(@NotNull TFlowNode tFlowNode) {
            return this.getAssociatedProcessAndNode(tFlowNode) != null;
        }

        private boolean isServiceConversation(@NotNull TFlowNode tFlowNode) {
            return this.getServiceAndOperation(tFlowNode) != null;
        }

        private boolean isDefinitionConversation(@NotNull TFlowNode tFlowNode) {
            return this.getDefinedOperationAndSync(tFlowNode) != null;
        }

        private boolean isMessageWithError(@NotNull TFlowNode tFlowNode) {
            TEvent tEvent;
            TMessageEventDefinition messageEventDefinition;
            boolean result = false;
            if (tFlowNode instanceof TEvent && (messageEventDefinition = this.getMessageEventDefinition(tEvent = (TEvent)tFlowNode)) != null) {
                result = this.getMessageErrorEventDefinition(messageEventDefinition) != null;
            }
            return result;
        }

        private Tuple<String, String> getAssociatedProcessAndNode(@NotNull TFlowNode tFlowNode) {
            Tuple result = null;
            String associatedProcess = this.getStringFeature(tFlowNode, "associatedProcess");
            String associatedNode = this.getStringFeature(tFlowNode, "associatedNode");
            if (!Str.isEmpty((String)associatedProcess) && !Str.isEmpty((String)associatedNode)) {
                result = Tuple.create((Object)associatedProcess, (Object)associatedNode);
            }
            return result;
        }

        private Tuple<String, String> getServiceAndOperation(@NotNull TFlowNode tFlowNode) {
            QName messageRef;
            TEvent tEvent;
            TMessageEventDefinition messageEventDefinition;
            Tuple result = null;
            String service = null;
            String operation = null;
            if (tFlowNode instanceof TSendTask) {
                TSendTask tSendTask = (TSendTask)tFlowNode;
                QName messageRef2 = tSendTask.getMessageRef();
                if (messageRef2 != null) {
                    service = messageRef2.getLocalPart();
                    QName operationRef = tSendTask.getOperationRef();
                    if (operationRef != null) {
                        operation = operationRef.getLocalPart();
                    }
                }
            } else if (tFlowNode instanceof TReceiveTask) {
                TReceiveTask tReceiveTask = (TReceiveTask)tFlowNode;
                QName messageRef3 = tReceiveTask.getMessageRef();
                if (messageRef3 != null) {
                    service = messageRef3.getLocalPart();
                    QName operationRef = tReceiveTask.getOperationRef();
                    if (operationRef != null) {
                        operation = operationRef.getLocalPart();
                    }
                }
            } else if (tFlowNode instanceof TServiceTask) {
                TServiceTask tServiceTask = (TServiceTask)tFlowNode;
                service = tServiceTask.getImplementation();
                QName operationRef = tServiceTask.getOperationRef();
                if (operationRef != null) {
                    operation = operationRef.getLocalPart();
                }
            } else if (tFlowNode instanceof TEvent && (messageEventDefinition = this.getMessageEventDefinition(tEvent = (TEvent)tFlowNode)) != null && (messageRef = messageEventDefinition.getMessageRef()) != null) {
                service = messageRef.getLocalPart();
                QName operationRef = messageEventDefinition.getOperationRef();
                if (operationRef != null) {
                    operation = operationRef.getLocalPart();
                }
            }
            if (!Str.isEmpty((String)service) && !Str.isEmpty(operation)) {
                result = Tuple.create((Object)service, operation);
            }
            return result;
        }

        private Tuple<String, Boolean> getDefinedOperationAndSync(@NotNull TFlowNode tFlowNode) {
            Tuple result = null;
            String definedOperationName = this.getStringFeature(tFlowNode, "definedOperationName");
            Boolean isSync = this.getBooleanFeature(tFlowNode, "sync");
            if (!Str.isEmpty((String)definedOperationName) && isSync != null) {
                result = Tuple.create((Object)definedOperationName, (Object)isSync);
            }
            return result;
        }

        private Tuple<String, TTypeRef> getMessageEventAssociatedError(@NotNull TFlowNode tFlowNode) {
            TErrorEventDefinition tErrorEventDefinition;
            TEvent tEvent;
            TMessageEventDefinition messageEventDefinition;
            Tuple result = null;
            if (tFlowNode instanceof TEvent && (messageEventDefinition = this.getMessageEventDefinition(tEvent = (TEvent)tFlowNode)) != null && (tErrorEventDefinition = this.getMessageErrorEventDefinition(messageEventDefinition)) != null) {
                TOracleExtensions errorOracleExtensions;
                String errorName = null;
                TTypeRef tTypeRef = null;
                QName errorRef = tErrorEventDefinition.getErrorRef();
                if (errorRef != null) {
                    errorName = errorRef.getLocalPart();
                }
                if ((errorOracleExtensions = this.getOrCreateOracleExtensionsFor(tErrorEventDefinition)) != null) {
                    tTypeRef = errorOracleExtensions.getTypeRef();
                }
                if (!Str.isEmpty((String)errorName) || tTypeRef != null) {
                    result = Tuple.create((Object)errorName, (Object)tTypeRef);
                }
            }
            return result;
        }

        private Sequence<TFlowNode> getAllConversationals() {
            ArrayList<TFlowNode> result = new ArrayList<TFlowNode>();
            result.addAll(this.processConversationalNodes.values());
            result.addAll(this.subprocessesConversationalNodes.values());
            return CollectionUtils.asSequence(result);
        }

        private TFlowNode findTFlowNode(@NotNull String id) {
            TFlowNode result = this.processConversationalNodes.get(id);
            if (result == null) {
                result = this.subprocessesConversationalNodes.get(id);
            }
            return result;
        }

        private TFlowNode getInitiator(@NotNull TFlowNode tFlowNode) {
            TFlowNode result = null;
            String initiatorId = this.getStringFeature(tFlowNode, "initiator");
            if (!Str.isEmpty((String)initiatorId)) {
                result = this.findTFlowNode(initiatorId);
            }
            return result;
        }

        private TMessageEventDefinition getMessageEventDefinition(@NotNull TEvent tEvent) {
            TMessageEventDefinition result = null;
            List<JAXBElement<? extends TEventDefinition>> definitionsList = tEvent instanceof TCatchEvent ? ((TCatchEvent)tEvent).getEventDefinition() : ((TThrowEvent)tEvent).getEventDefinition();
            for (JAXBElement<? extends TEventDefinition> element : definitionsList) {
                TEventDefinition tEventDefinition = (TEventDefinition)element.getValue();
                if (!(tEventDefinition instanceof TMessageEventDefinition)) continue;
                result = (TMessageEventDefinition)tEventDefinition;
                break;
            }
            return result;
        }

        private TErrorEventDefinition getMessageErrorEventDefinition(@NotNull TMessageEventDefinition tMessageEventDefinition) {
            TErrorEventDefinition result = null;
            TOracleExtensions messageExtensions = this.getOrCreateOracleExtensionsFor(tMessageEventDefinition);
            for (Object extension : messageExtensions.getAny()) {
                JAXBElement jaxbElement;
                Object value;
                if (!(extension instanceof JAXBElement) || !((value = (jaxbElement = (JAXBElement)extension).getValue()) instanceof TErrorEventDefinition)) continue;
                result = (TErrorEventDefinition)value;
                break;
            }
            return result;
        }

        private String getStringFeature(@NotNull TFlowNode tFlowNode, @NotNull String featureName) {
            String result = null;
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFlowNode);
            TFeatureSet tFeatureSet = tOracleExtensions.getFeatureSet();
            if (tFeatureSet != null) {
                List<TStringFeature> features = tFeatureSet.getStringFeature();
                for (TStringFeature feature : features) {
                    if (!featureName.equals(feature.getName())) continue;
                    result = feature.getValue();
                    break;
                }
            }
            return result;
        }

        private Boolean getBooleanFeature(@NotNull TFlowNode tFlowNode, @NotNull String featureName) {
            Boolean result = null;
            TOracleExtensions tOracleExtensions = this.getOrCreateOracleExtensionsFor(tFlowNode);
            TFeatureSet tFeatureSet = tOracleExtensions.getFeatureSet();
            if (tFeatureSet != null) {
                List<TBooleanFeature> features = tFeatureSet.getBooleanFeature();
                for (TBooleanFeature feature : features) {
                    if (!featureName.equals(feature.getName())) continue;
                    result = feature.isValue();
                    break;
                }
            }
            return result;
        }

        private TConversation getOrCreateDefinitionConversation() {
            if (this.definitionConversation == null) {
                this.definitionConversation = this.extensionsFactory.createTConversation();
                this.definitionConversation.setId(this.getNextConversationId());
                this.definitionConversation.setType(ConversationType.DEFINE_INTERFACE.getId());
                TDefineInterfaceConversationDefinition definition = this.extensionsFactory.createTDefineInterfaceConversationDefinition();
                this.definitionConversation.setDefineInterfaceConversationDefinition(definition);
            }
            return this.definitionConversation;
        }

        private TConversation getOrCreateUseReferenceConversation(@NotNull String reference) {
            TConversation result;
            if (this.useReferenceConversations.containsKey(reference)) {
                result = this.useReferenceConversations.get(reference);
            } else {
                result = this.extensionsFactory.createTConversation();
                result.setId(this.getNextConversationId());
                result.setType(ConversationType.USE_INTERFACE.getId());
                TUseInterfaceConversationDefinition definition = this.extensionsFactory.createTUseInterfaceConversationDefinition();
                definition.setReference(reference);
                result.setUseInterfaceConversationDefinition(definition);
                this.useReferenceConversations.put(reference, result);
            }
            return result;
        }

        private TConversation getOrCreateServiceCallConversation(@NotNull String service) {
            TConversation result;
            if (this.serviceCallConversations.containsKey(service)) {
                result = this.serviceCallConversations.get(service);
            } else {
                result = this.extensionsFactory.createTConversation();
                result.setId(this.getNextConversationId());
                result.setType(ConversationType.SERVICE_CALL.getId());
                TServiceCallConversationDefinition definition = this.extensionsFactory.createTServiceCallConversationDefinition();
                definition.setService(service);
                result.setServiceCallConversationDefinition(definition);
                this.serviceCallConversations.put(service, result);
            }
            return result;
        }

        private TConversation getOrCreateProcessCallConversation(@NotNull String process) {
            TConversation result;
            if (this.processCallConversations.containsKey(process)) {
                result = this.processCallConversations.get(process);
            } else {
                result = this.extensionsFactory.createTConversation();
                result.setId(this.getNextConversationId());
                result.setType(ConversationType.PROCESS_CALL.getId());
                TProcessCallConversationDefinition definition = this.extensionsFactory.createTProcessCallConversationDefinition();
                definition.setProcess(process);
                result.setProcessCallConversationDefinition(definition);
                this.processCallConversations.put(process, result);
            }
            return result;
        }

        private TOracleExtensions getOrCreateOracleExtensionsFor(TBaseElement tElement) {
            TOracleExtensions extensions = IoUtils.findOracleExtensionsIn(tElement);
            if (extensions == null) {
                extensions = this.extensionsFactory.createTOracleExtensions();
                TExtensionElements extensionElements = this.getOrCreateExtensionsFor(tElement);
                extensionElements.getAny().add(this.extensionsFactory.createOracleExtensions(extensions));
            }
            return extensions;
        }

        private TExtensionElements getOrCreateExtensionsFor(TBaseElement tElement) {
            TExtensionElements result = IoUtils.findExtensionsIn(tElement);
            if (result == null) {
                result = this.objectFactory.createTExtensionElements();
                tElement.setExtensionElements(result);
            }
            return result;
        }

        private String getNextConversationId() {
            String result;
            String prepend = "#" + this.tProcess.getId().hashCode() + "_";
            while (this.usedConversationIds.contains(result = prepend + ConversationalHelper.createRandomConversationId())) {
            }
            this.usedConversationIds.add(result);
            return result;
        }
    }
}

