/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.model;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.project.compile.process.ProcessFixer;
import oracle.bpm.project.io.bpmn.jaxb.ObjectFactory;
import oracle.bpm.project.io.serializers.model.ModelFormat;
import oracle.bpm.project.io.serializers.model.ModelParseException;
import oracle.bpm.project.io.serializers.model.bpmn.BPMN20Loader;
import oracle.bpm.project.io.serializers.model.bpmn.BPMNVersionParser;
import oracle.bpm.project.io.serializers.model.bpmn.ProcessVisitorBPMN;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.TransformationException;
import oracle.bpm.project.io.serializers.model.bpmn.transformation.TransformationManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.FileRevisionFeature;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.xml.JaxbHelper;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultModelFormat
implements ModelFormat {
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class, oracle.bpm.project.io.bpmn.jaxb.extensions.ObjectFactory.class});

    public static void load(Process process, InputStream stream) throws ProjectException {
        DefaultModelFormat.loadInternal(process, stream, false);
    }

    public static void load(Process process, File sourceFile) throws ProjectException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(sourceFile);
        try {
            DefaultModelFormat.load(process, fileInputStream);
        }
        catch (Exception e) {
            try {
                throw ProjectException.wrap((ProjectObject)process, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{fileInputStream});
    }

    public static Process createFrom(@NotNull Project project, @NotNull File file) throws ProjectException, FileNotFoundException {
        Process process = project.createModel("");
        DefaultModelFormat.load(process, file);
        return process;
    }

    @Override
    public void writeXml(Process process, Writer writer) throws IOException, ProjectException {
        this.writeBpmn20(process, writer);
    }

    @Override
    public Object parse(InputStream is, Project project, Process processContent, boolean onlyInfo) throws ProjectException {
        DefaultModelFormat.load(processContent, is);
        return processContent;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadBPMN20CompliantModel(Process process, InputStream inputStream) throws ProjectException, ParserException, UnsupportedEncodingException {
        process.init();
        InputStream input = null;
        try {
            byte[] bytes = StreamUtils.readBytes((InputStream)inputStream);
            Tuple<String, Integer> versionAndRevision = BPMNVersionParser.getVersionAndRevision(new ByteArrayInputStream(bytes));
            FileRevisionFeature revisionFeature = process.getFeature(FileRevisionFeature.class);
            String version = (String)versionAndRevision.getFirst();
            Integer revisionNumber = (Integer)versionAndRevision.getSecond();
            revisionFeature.setVersion(version);
            revisionFeature.setRevision(revisionNumber);
            input = new ByteArrayInputStream(bytes);
            Integer latestVersion = Integer.valueOf("20120217");
            if (!latestVersion.equals(revisionNumber)) {
                input = TransformationManager.transform(input, revisionNumber, latestVersion);
            }
            BPMN20Loader bpmn20Loader = new BPMN20Loader(process, input, revisionNumber, latestVersion);
            bpmn20Loader.load();
            DefaultModelFormat.processFix(process);
        }
        catch (IOException e) {
            try {
                throw ProjectException.wrap((ProjectObject)process, e);
                catch (TransformationException e2) {
                    throw ProjectException.wrap((ProjectObject)process, (Throwable)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{input});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{input});
    }

    private static void processFix(Process process) throws ProjectException {
        Sequence<Gateway> gateways;
        if (process != null && (gateways = process.getGateways()) != null) {
            Iterator iterator = gateways.iterator();
            boolean exitToValidate = false;
            while (iterator.hasNext() && !exitToValidate) {
                Gateway gateway = (Gateway)iterator.next();
                if (!gateway.is(InclusiveGateway.class) && !gateway.is(ParallelGateway.class) && !gateway.is(ComplexGateway.class) || ModelUtils.getAssociatedFlowNode(gateway) != null) continue;
                exitToValidate = true;
            }
            if (exitToValidate) {
                ProcessFixer processFixer = new ProcessFixer(process);
                processFixer.check();
            }
        }
    }

    private static void loadInternal(Process model, InputStream stream, boolean infoOnly) throws ProjectException {
        try {
            DefaultModelFormat.loadBPMN20CompliantModel(model, stream);
        }
        catch (ParserException e) {
            throw ModelParseException.wrap((ProjectObject)model, e);
        }
        catch (UnsupportedEncodingException e) {
            throw ProjectException.wrap((ProjectObject)model, e);
        }
    }

    private void writeBpmn20(Process process, Writer writer) throws ProjectException {
        ProcessVisitorBPMN processVisitor = new ProcessVisitorBPMN();
        process.visit(processVisitor);
        try {
            JAXBContext jaxbContext = JAXB_CONTEXT;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.omg.org/spec/BPMN/20100524/MODEL");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            marshaller.marshal(processVisitor.getDefinitions(), writer);
        }
        catch (Exception e) {
            try {
                throw ProjectException.wrap((ProjectObject)process, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{writer});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{writer});
    }
}

