/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.serializers.activityguide;

import oracle.bpm.project.io.activityGuide.jaxb.ObjectFactory;
import oracle.bpm.project.io.activityGuide.jaxb.TActivityGuide;
import oracle.bpm.project.io.activityGuide.jaxb.TDisplayMode;
import oracle.bpm.project.io.activityGuide.jaxb.TMilestone;
import oracle.bpm.project.io.activityGuide.jaxb.TResourceBundle;
import oracle.bpm.project.io.activityGuide.jaxb.TTaskAcessMode;
import oracle.bpm.project.io.activityGuide.jaxb.TTranslatableValue;
import oracle.bpm.project.io.activityGuide.jaxb.TTranslatableValueEnum;
import oracle.bpm.project.io.activityGuide.jaxb.TUserTask;
import oracle.bpm.project.model.ProjectVisitorAdapter;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.activityguide.MilestoneActivity;
import oracle.bpm.project.model.activityguide.TranslationType;
import oracle.bpm.project.model.exception.ProjectException;

public class ActivityGuideVisitor
extends ProjectVisitorAdapter {
    private ObjectFactory objectFactory = new ObjectFactory();
    private TActivityGuide tActivityGuide;

    public TActivityGuide getTActivityGuide() {
        if (this.tActivityGuide == null) {
            this.tActivityGuide = this.objectFactory.createTActivityGuide();
        }
        return this.tActivityGuide;
    }

    @Override
    public void visit(ActivityGuide activityGuide) throws ProjectException {
        this.getTActivityGuide().setId(activityGuide.getId());
        TTranslatableValue titleValue = this.objectFactory.createTTranslatableValue();
        if (activityGuide.getTranslatableTitle().getType() == TranslationType.STATIC) {
            titleValue.setType(TTranslatableValueEnum.STATIC);
        } else {
            titleValue.setType(TTranslatableValueEnum.RESOURCE);
        }
        titleValue.setValue(activityGuide.getTranslatableTitle().getValue());
        this.getTActivityGuide().setTitle(titleValue);
        TTranslatableValue descriptionValue = this.objectFactory.createTTranslatableValue();
        if (activityGuide.getTranslatableDescription().getType() == TranslationType.STATIC) {
            descriptionValue.setType(TTranslatableValueEnum.STATIC);
        } else {
            descriptionValue.setType(TTranslatableValueEnum.RESOURCE);
        }
        descriptionValue.setValue(activityGuide.getTranslatableDescription().getValue());
        this.getTActivityGuide().setDescription(descriptionValue);
        this.getTActivityGuide().setRootProcessRef(activityGuide.getRootProcess() != null ? activityGuide.getRootProcess().getId() : null);
        this.getTActivityGuide().setGlobalDisplayMode(TDisplayMode.valueOf(activityGuide.getDisplayMode().name()));
        this.getTActivityGuide().setGlobalTaskAccessMode(TTaskAcessMode.valueOf(activityGuide.getTaskAccessMode().name()));
        this.getTActivityGuide().setIconLocation(activityGuide.getIconLocation());
        if (activityGuide.getResourceBundle() != null) {
            TResourceBundle tResourceBundle = this.objectFactory.createTResourceBundle();
            tResourceBundle.setName(activityGuide.getResourceBundle().getName());
            tResourceBundle.setLocation(activityGuide.getResourceBundle().getLocation());
            tResourceBundle.setExternal(activityGuide.getResourceBundle().isExternal());
            this.getTActivityGuide().setResourceBundle(tResourceBundle);
        }
        this.visitMilestones(activityGuide);
        this.visitActivities(activityGuide);
    }

    @Override
    public void visit(Milestone milestone) throws ProjectException {
        TActivityGuide tActivityGuide = this.getTActivityGuide();
        TMilestone tMilestone = this.objectFactory.createTMilestone();
        tMilestone.setId(milestone.getId());
        TTranslatableValue titleValue = this.objectFactory.createTTranslatableValue();
        if (milestone.getTranslatableTitle().getType() == TranslationType.STATIC) {
            titleValue.setType(TTranslatableValueEnum.STATIC);
        } else {
            titleValue.setType(TTranslatableValueEnum.RESOURCE);
        }
        titleValue.setValue(milestone.getTranslatableTitle().getValue());
        tMilestone.setTitle(titleValue);
        TTranslatableValue descriptionValue = this.objectFactory.createTTranslatableValue();
        if (milestone.getTranslatableDescription().getType() == TranslationType.STATIC) {
            descriptionValue.setType(TTranslatableValueEnum.STATIC);
        } else {
            descriptionValue.setType(TTranslatableValueEnum.RESOURCE);
        }
        descriptionValue.setValue(milestone.getTranslatableDescription().getValue());
        tMilestone.setDescription(descriptionValue);
        tMilestone.setIconLocation(milestone.getIconLocation());
        tMilestone.setMilestoneDisplayMode(TDisplayMode.valueOf(milestone.getDisplayMode().name()));
        tMilestone.setTotalTaskLeft(milestone.getTasksRemaining());
        this.getTActivityGuide().getMilestone().add(tMilestone);
    }

    @Override
    public void visit(MilestoneActivity milestoneActivity) throws ProjectException {
        Milestone milestone = milestoneActivity.getMilestone();
        TUserTask tUserTask = this.objectFactory.createTUserTask();
        tUserTask.setIdRef(milestoneActivity.getActivityRef().getId());
        tUserTask.setProcessIdRef(milestoneActivity.getActivityRef().getProcessId());
        tUserTask.setPosition(milestoneActivity.getPosition());
        tUserTask.setMarkedOptional(milestoneActivity.isMarkedAsOptional());
        tUserTask.setDisplayBlockedIcon(milestoneActivity.isDisplayBlockedIcon());
        TTranslatableValue blockedIconTTranslatableValue = this.objectFactory.createTTranslatableValue();
        if (milestoneActivity.getTranslatableBlockedIconText().getType() == TranslationType.STATIC) {
            blockedIconTTranslatableValue.setType(TTranslatableValueEnum.STATIC);
        } else {
            blockedIconTTranslatableValue.setType(TTranslatableValueEnum.RESOURCE);
        }
        blockedIconTTranslatableValue.setValue(milestoneActivity.getTranslatableBlockedIconText().getValue());
        tUserTask.setDisplayBlockedIconText(blockedIconTTranslatableValue);
        tUserTask.setTotalTaskLeft(milestoneActivity.getTasksRemaining());
        tUserTask.setTaskDisplayMode(TDisplayMode.valueOf(milestoneActivity.getDisplayMode().name()));
        tUserTask.setLastTask(milestoneActivity.equals(milestoneActivity.getMilestone().getLastTask()));
        TMilestone tMilestone = this.findMilestone(milestone);
        tMilestone.getUserTaskOrMilestone().add(tUserTask);
    }

    private void visitActivities(ActivityGuide activityGuide) throws ProjectException {
        for (Milestone milestone : activityGuide.getChildrenByType(Milestone.class)) {
            this.visitActivities(milestone);
        }
    }

    private void visitMilestones(ActivityGuide activityGuide) throws ProjectException {
        for (Milestone miletone : activityGuide.getChildrenByType(Milestone.class)) {
            miletone.visit(this);
        }
    }

    private void visitActivities(Milestone milestone) throws ProjectException {
        for (MilestoneActivity milestoneActivity : milestone.getChildrenByType(MilestoneActivity.class)) {
            milestoneActivity.visit(this);
        }
    }

    private TMilestone findMilestone(Milestone milestone) {
        for (TMilestone tMilestone : this.tActivityGuide.getMilestone()) {
            if (!tMilestone.getId().equals(milestone.getId())) continue;
            return tMilestone;
        }
        return null;
    }
}

