/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import oracle.bpm.analytics.measurement.metadata.model.Actions;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.analytics.measurement.metadata.model.TPropertyType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.project.io.sensor.MeasurementActionsFileGenerator;
import oracle.bpm.project.kpi.BamActionImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.kpi.MeasurementAction;
import oracle.bpm.project.model.kpi.MeasurementActions;
import oracle.bpm.xmlparser.ParserException;

public class MeasurementActionsLoader {
    private Project project;
    private static JAXBContext jaxbContext;

    public MeasurementActionsLoader(Project project) {
        this.project = project;
    }

    public void loadMeasurementActions(ProjectPreferences preferences) {
        MeasurementActions actionsContainer = preferences.getKeyPerformanceIndicatorsContainer().getActionsContainer();
        VFile measurementActionsVFile = new MeasurementActionsFileGenerator(this.project).getMeasurementActionsFile();
        try {
            VFileInputStream is = new VFileInputStream(measurementActionsVFile);
            JAXBContext jc = jaxbContext;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal((InputStream)is);
            if (!(unmarshalledObject instanceof Actions)) {
                throw new ParserException("Invalid JAXB element found");
            }
            this.load((Actions)unmarshalledObject, actionsContainer);
        }
        catch (IOException e) {
            new ProjectException(actionsContainer, null, e).printStackTrace();
        }
        catch (JAXBException e) {
            new ProjectException(actionsContainer, null, e).printStackTrace();
        }
        catch (ParserException e) {
            new ProjectException(actionsContainer, null, e).printStackTrace();
        }
        catch (ProjectException e) {
            new ProjectException(actionsContainer, null, (Throwable)((Object)e)).printStackTrace();
        }
    }

    private void load(Actions tActions, MeasurementActions actionsContainer) throws ProjectException {
        for (TAction tAction : tActions.getAction()) {
            MeasurementAction action = actionsContainer.findAction(tAction.getName());
            if (action == null) continue;
            action.setName(tAction.getName());
            action.setEnable(tAction.isEnabled());
            action.setInterfaceName(tAction.getInterfaceName());
            if (tAction.getProperties() == null || !action.getId().equals("BAMCommand")) continue;
            this.loadBamActionProperties(tAction, (BamActionImpl)action);
        }
    }

    private void loadBamActionProperties(TAction tAction, BamActionImpl bamAction) {
        for (TPropertyType tPropertyType : tAction.getProperties().getProperty()) {
            if (tPropertyType.getName().equals("BAMAdapterJNDIName")) {
                bamAction.setBamAdapterJNDIName(tPropertyType.getValue());
                continue;
            }
            if (tPropertyType.getName().equals("DataObjectPath")) {
                bamAction.setDataObjectPath(tPropertyType.getValue());
                continue;
            }
            if (tPropertyType.getName().equals("InBatch")) {
                bamAction.setInBatch(Boolean.valueOf(tPropertyType.getValue()).booleanValue());
                continue;
            }
            if (tPropertyType.getName().equals("CachedConnections")) {
                bamAction.setCachedConnection(Boolean.valueOf(tPropertyType.getValue()).booleanValue());
                continue;
            }
            if (!tPropertyType.getName().equals("BAMDeploymentUseHTTPS")) continue;
            bamAction.setUseHTTPS(Boolean.valueOf(tPropertyType.getValue()).booleanValue());
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

