/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.sensor;

import oracle.bpm.analytics.measurement.metadata.model.Actions;
import oracle.bpm.analytics.measurement.metadata.model.Measurements;
import oracle.bpm.analytics.measurement.metadata.model.ObjectFactory;
import oracle.bpm.analytics.measurement.metadata.model.TAction;
import oracle.bpm.analytics.measurement.metadata.model.TElementSelection;
import oracle.bpm.analytics.measurement.metadata.model.TMeasurementElement;
import oracle.bpm.analytics.measurement.metadata.model.TProperties;
import oracle.bpm.analytics.measurement.metadata.model.TPropertyType;
import oracle.bpm.project.kpi.BamActionImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.kpi.KeyPerformanceIndicatorsContainer;
import oracle.bpm.project.model.kpi.MeasurementAction;

public class MeasurementActionsBuilder {
    private Measurements measurements;
    private ObjectFactory objectFactory = new ObjectFactory();
    private Project project;

    public MeasurementActionsBuilder(Project project, Measurements measurements) {
        this.measurements = measurements;
        this.project = project;
    }

    public Actions build() {
        Actions tActions = this.objectFactory.createActions();
        tActions.setCompositeDN(this.measurements.getCompositeDN());
        KeyPerformanceIndicatorsContainer kpisContainer = this.project.getPreferences().getKeyPerformanceIndicatorsContainer();
        for (MeasurementAction measurementAction : kpisContainer.getMeasurementActions()) {
            TAction tAction = this.objectFactory.createTAction();
            tAction.setEnabled(measurementAction.isEnable());
            tAction.setName(measurementAction.getName());
            tAction.setInterfaceName(measurementAction.getInterfaceName());
            TProperties tProperties = this.objectFactory.createTProperties();
            if (measurementAction.getId().equals("BAMCommand")) {
                this.buildBamActionTProperties(tProperties, (BamActionImpl)measurementAction);
            }
            tAction.setProperties(tProperties);
            for (TMeasurementElement tMeasurementElement : this.measurements.getMeasurementElements().getMeasurementElement()) {
                if (tMeasurementElement.getElementSelection() == TElementSelection.NONE) continue;
                tAction.getMeasurementElementName().add(tMeasurementElement.getName());
            }
            tActions.getAction().add(tAction);
        }
        return tActions;
    }

    private void buildBamActionTProperties(TProperties tProperties, BamActionImpl bamAction) {
        if (bamAction.getBamAdapterJNDIName() != null) {
            TPropertyType bamAdapterJNDINameTPropertyType = this.objectFactory.createTPropertyType();
            bamAdapterJNDINameTPropertyType.setName("BAMAdapterJNDIName");
            bamAdapterJNDINameTPropertyType.setValue(bamAction.getBamAdapterJNDIName());
            tProperties.getProperty().add(bamAdapterJNDINameTPropertyType);
        }
        TPropertyType inBatchTPropertyType = this.objectFactory.createTPropertyType();
        inBatchTPropertyType.setName("InBatch");
        inBatchTPropertyType.setValue(String.valueOf(bamAction.isInBatch()));
        tProperties.getProperty().add(inBatchTPropertyType);
        TPropertyType cachedConnectionsTPropertyType = this.objectFactory.createTPropertyType();
        cachedConnectionsTPropertyType.setName("CachedConnections");
        cachedConnectionsTPropertyType.setValue(String.valueOf(bamAction.isCachedConnections()));
        tProperties.getProperty().add(cachedConnectionsTPropertyType);
        TPropertyType dataObjectPathTPropertyType = this.objectFactory.createTPropertyType();
        dataObjectPathTPropertyType.setName("DataObjectPath");
        dataObjectPathTPropertyType.setValue(bamAction.getDataObjectPath());
        tProperties.getProperty().add(dataObjectPathTPropertyType);
        TPropertyType useHTTPSTPropertyType = this.objectFactory.createTPropertyType();
        useHTTPSTPropertyType.setName("BAMDeploymentUseHTTPS");
        useHTTPSTPropertyType.setValue(String.valueOf(bamAction.isUseHTTPS()));
        tProperties.getProperty().add(useHTTPSTPropertyType);
    }
}

