/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.recognizer;

import java.io.File;
import oracle.bpm.project.io.recognizer.FileInputSource;
import oracle.bpm.project.io.recognizer.ProjectRecognizer;
import oracle.bpm.project.model.ProjectObject;

public class RecognizerTester {
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            throw new RuntimeException("A File path should be passed as an argument!");
        }
        ProjectRecognizer recognizer = ProjectRecognizer.getInstance();
        File file = new File(args[0]);
        RecognizerTester.recognizeFileOrDirectory(recognizer, file);
    }

    private static void recognizeFileOrDirectory(ProjectRecognizer recognizer, File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                RecognizerTester.recognizeFileOrDirectory(recognizer, child);
            }
        } else {
            RecognizerTester.recognizeFile(recognizer, file);
        }
    }

    private static void recognizeFile(ProjectRecognizer recognizer, File file) {
        FileInputSource inputSource = FileInputSource.create(file);
        Class<? extends ProjectObject> recognizedClass = recognizer.recognize(inputSource);
        System.out.println("File: " + file + " >>>> " + recognizedClass.toString());
    }
}

