/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.serializers.simulation.project.ProjectSimulationJaxbVisitor;
import oracle.bpm.project.io.simulation.jaxb.project.ObjectFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.xml.JaxbHelper;

@ProjectObjectWriterMetadata(objectClasses={ProjectSimulation.class})
public class ProjectSimulationWriter
extends AbstractWriter {
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class});

    @Override
    public void write(ProjectObject projectObject, OutputStream outputStream) throws IOException, ProjectException {
        assert (projectObject instanceof ProjectSimulation) : "projectObject must be instance of ProjectSimulation";
        ProjectSimulationJaxbVisitor jaxbVisitor = ProjectSimulationJaxbVisitor.create();
        ProjectSimulation projectSimulation = (ProjectSimulation)projectObject;
        projectSimulation.visit(jaxbVisitor);
        try {
            JAXBContext jaxbContext = JAXB_CONTEXT;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)jaxbVisitor.getJaxbProjectSimulation(), outputStream);
        }
        catch (Exception e) {
            try {
                throw ProjectException.wrap((ProjectObject)projectSimulation, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{outputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{outputStream});
    }
}

