/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.bpm.casemgmt.caserule.CaseDictionaryHandler;
import oracle.bpm.casemgmt.compositeutil.CompositeCaseUtil;
import oracle.bpm.casemgmt.compositeutil.exceptions.CompositeCaseUtilException;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.PropertyBundles;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.casemgmt.model.cm.persistence.CasePersistenceManager;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.diff.DiffNode;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Str;
import oracle.bpm.project.io.fs.loader.ProjectCaseLoader;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.LocalFileSystem;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.casemgmt.CaseContainer;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.util.Properties;
import oracle.rules.sdk2.dictionary.RuleDictionary;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={ProjectCase.class})
public class ProjectCaseWriter
extends AbstractWriter {
    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        ProjectCase projectCase = (ProjectCase)projectObject;
        VFile file = this.getFile(projectCase);
        boolean isCaseCreation = !file.exists();
        Case caseSaved = null;
        if (!isCaseCreation) {
            caseSaved = ProjectCaseWriter.loadCase(file);
        }
        VFile result = super.write(projectObject);
        Case casemgmt = projectCase.getCase();
        try {
            ResourceBundleWriter.write(projectCase.getProject(), casemgmt.getPropertyBundles());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (isCaseCreation) {
            this.updateArtifactsForCaseCreation(projectCase);
        } else {
            boolean caseDataChanged = true;
            if (caseSaved != null) {
                CaseData caseDataNew;
                CaseData caseDataOld;
                DiffNode diff;
                List caseDataListOld = caseSaved.getCaseData();
                List caseDataListNew = casemgmt.getCaseData();
                if (caseDataListOld.size() >= 1 && caseDataListNew.size() >= 1 && (diff = (caseDataOld = (CaseData)caseDataListOld.get(0)).getDiff((Entity)(caseDataNew = (CaseData)caseDataListNew.get(0)))) == null) {
                    caseDataChanged = false;
                }
            }
            this.updateArtifactsForCaseUpdate(projectCase, caseDataChanged);
        }
        return result;
    }

    @Override
    public void write(ProjectObject projectObject, OutputStream outputStream) throws IOException, ProjectException {
        ProjectCase projectCase = (ProjectCase)projectObject;
        Case casemgmt = projectCase.getCase();
        CasePersistenceManager.INSTANCE.save(outputStream, (Entity)casemgmt);
    }

    @Override
    public void delete(@NotNull ProjectObject projectObject) throws ProjectException {
        VFile[] bundlesFiles;
        ProjectCase projectCase = (ProjectCase)projectObject;
        Project project = projectCase.getProject();
        Collection<ProjectCaseActivity> caseActivities = projectCase.getCaseActivities();
        for (ProjectCaseActivity caseActivity : caseActivities) {
            caseActivity.delete();
        }
        super.delete(projectObject);
        this.updateArtifactsForCaseDeletion(projectCase);
        Case casemgmt = projectCase.getCase();
        VFile folder = ProjectCaseLoader.ResourceBundleLoader.getResourcesFolder(project);
        for (VFile vFile : bundlesFiles = ProjectCaseLoader.ResourceBundleLoader.getBundles(folder, casemgmt.getResourceBundle())) {
            vFile.delete();
        }
        ProjectObject parentObject = projectCase.getParentObject();
        if (parentObject instanceof CaseContainer) {
            VFile caseFile = this.getFile(projectCase);
            if (caseFile != null) {
                VFile caseFolderFile = caseFile.getParentFile();
                if (Path.CASE.getName().equals(caseFolderFile.getName())) {
                    caseFolderFile.delete();
                }
            }
            parentObject.delete();
        }
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        ProjectCase projectCase = (ProjectCase)projectObject;
        Case casemgmt = projectCase.getCase();
        VFile folder = this.getContainerFolder(projectObject);
        String fileName = casemgmt.getName() + ".case";
        ProjectWriter writer = projectObject.getProject().getWriter();
        VFileSystem dataFileSystem = writer.getProjectFileSystem().getDataFileSystem();
        return dataFileSystem.createFile(folder, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Case loadCase(VFile file) {
        Case result = null;
        VFileInputStream is = null;
        try {
            is = new VFileInputStream(file);
            result = (Case)CasePersistenceManager.INSTANCE.load((InputStream)is);
        }
        catch (IOException iOException) {
            StreamUtils.close((Closeable[])new Closeable[]{is});
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{is});
        return result;
    }

    private void updateArtifactsForCaseCreation(ProjectCase projectCase) {
        try {
            Project project = projectCase.getProject();
            Case casemgmt = projectCase.getCase();
            CompositeCaseUtil.create((Project)project).addCase(casemgmt.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RulesIntegrationWriter.create(projectCase).writeOnCaseCreation();
    }

    private void updateArtifactsForCaseDeletion(ProjectCase projectCase) {
        Project project = projectCase.getProject();
        Case casemgmt = projectCase.getCase();
        String caseName = casemgmt.getName();
        RulesIntegrationWriter.deleteRulesOnCaseDeletion(projectCase.getProject(), caseName);
        try {
            CompositeCaseUtil.create((Project)project).removeCase(casemgmt.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateArtifactsForCaseUpdate(ProjectCase projectCase, boolean caseDataChanged) {
        OrganizationIntegrationWriter.create(projectCase).writeOnCaseUpdate();
        if (caseDataChanged) {
            RulesIntegrationWriter.create(projectCase).writeOnCaseUpdate();
        }
    }

    private static class RulesIntegrationWriter {
        private Project project;
        private ProjectCase projectCase;
        static final String DECISION_SUFFIX = ".decs";
        static final String WSDL_SUFFIX = ".wsdl";
        static final String XSD = "xsd";
        static final String RULES_DIR = "oracle/rules";
        static final String RULES_SUFFIX = ".rules";
        static final String RULES = "Rules";

        private RulesIntegrationWriter(ProjectCase projectCase) {
            this.projectCase = projectCase;
            this.project = projectCase.getProject();
        }

        public static RulesIntegrationWriter create(ProjectCase projectCase) {
            return new RulesIntegrationWriter(projectCase);
        }

        public static void deleteRulesOnCaseDeletion(Project project, String caseName) {
            RulesIntegrationWriter.deleteFilesFromPreviousStep2Run(project, caseName, false);
            try {
                CompositeCaseUtil util = CompositeCaseUtil.create((Project)project);
                util.removeCaseRulesIntegration(caseName);
            }
            catch (CompositeCaseUtilException e) {
                e.printStackTrace();
            }
            String ruleComponentName = caseName + RULES;
            String rulesFileName1 = "oracle/rules/" + ruleComponentName + RULES_SUFFIX;
            String rulesFileName2 = "oracle/rules/" + ruleComponentName + "Base" + RULES_SUFFIX;
            String descriptionFileName = ruleComponentName + DECISION_SUFFIX;
            String[] fileList = new String[]{rulesFileName1, rulesFileName2, descriptionFileName};
            VFileSystem vFileSystem = project.getWriter().getProjectFileSystem().getDataFileSystem();
            VFile vFile = null;
            for (String fileName : fileList) {
                vFile = vFileSystem.createFile(fileName);
                if (!vFile.exists()) continue;
                vFile.delete();
            }
        }

        public static void deleteFilesFromPreviousStep2Run(Project project, String caseName, boolean deleteDesc) {
            String descriptionFileName;
            VFile vFile;
            String ruleComponentName = caseName + RULES;
            String serviceName = ruleComponentName + "_" + ruleComponentName;
            String wsdlFileName = serviceName + WSDL_SUFFIX;
            String xsdFileName1 = "xsd/" + serviceName + "MessageTypes." + XSD;
            String xsdFileName2 = "xsd/" + serviceName + "Types." + XSD;
            String[] fileList = new String[]{xsdFileName1, xsdFileName2, wsdlFileName};
            VFileSystem vFileSystem = project.getWriter().getProjectFileSystem().getDataFileSystem();
            for (String fileName : fileList) {
                VFile vFile2 = vFileSystem.createFile(fileName);
                if (!vFile2.exists()) continue;
                vFile2.delete();
            }
            if (deleteDesc && (vFile = vFileSystem.createFile(descriptionFileName = ruleComponentName + DECISION_SUFFIX)).exists()) {
                vFile.delete();
            }
        }

        public void writeOnCaseCreation() {
            Case casemgmt = this.projectCase.getCase();
            String caseName = casemgmt.getName();
            CompositeCaseUtil compositeCaseUtil = null;
            try {
                compositeCaseUtil = CompositeCaseUtil.create((Project)this.project);
            }
            catch (CompositeCaseUtilException e) {
                e.printStackTrace();
            }
            Map<CaseDictionaryHandler.DICTIONARY_TYPE, RuleDictionary> ruleDictionaryMap = this.caseRulesStep1(caseName);
            this.caseRulesStep2(caseName, ruleDictionaryMap);
            this.caseRulesStep345(compositeCaseUtil, caseName);
        }

        public void writeOnCaseUpdate() {
            Case casemgmt = this.projectCase.getCase();
            CaseData caseData = (CaseData)casemgmt.getCaseData().get(0);
            ArrayList<String> schemaList = new ArrayList<String>();
            ArrayList<String> caseInputXmlTypes = new ArrayList<String>();
            for (Data data : caseData) {
                if (!this.isValidData(data)) continue;
                String schema = data.getSchema();
                String type = data.getType();
                if (schema != null) {
                    schemaList.add(schema);
                }
                if (type == null) continue;
                caseInputXmlTypes.add(type);
            }
            Map<CaseDictionaryHandler.DICTIONARY_TYPE, RuleDictionary> ruleDictionaryMap = this.regenerateXMLFactTypes(schemaList, caseInputXmlTypes);
            if (ruleDictionaryMap == null || ruleDictionaryMap.isEmpty()) {
                System.out.println("Cannot regenerate RuleDictionary for Case: " + casemgmt.getName() + " with XSDs:");
                for (String schema : schemaList) {
                    System.out.println(schema);
                }
                System.out.println("with inputTypes:");
                for (String type : caseInputXmlTypes) {
                    System.out.println(type);
                }
                return;
            }
            this.caseRulesStep2(this.projectCase.getName(), ruleDictionaryMap);
        }

        private boolean isValidData(Data data) {
            return !Str.isEmpty((String)data.getType()) && data.getDataType() != null && !data.getDataType().isComplexType();
        }

        private Map<CaseDictionaryHandler.DICTIONARY_TYPE, RuleDictionary> caseRulesStep1(String caseName) {
            ProjectFileSystem projectFileSystem = this.project.getWriter().getProjectFileSystem();
            LocalFileSystem localFileSystem = projectFileSystem.getLocalFileSystem();
            String componentDir = localFileSystem.getRootFolder().getAbsolutePath();
            String componentName = caseName + RULES;
            ArrayList caseDataSchemaURIs = new ArrayList();
            Map result = null;
            URI caseSchemaURI = null;
            URI caseEventSchemaURI = null;
            URI caseActionSchemaURI = null;
            try {
                caseSchemaURI = new URL("oramds:/soa/shared/casemgmt/Case.xsd").toURI();
                caseEventSchemaURI = new URL("oramds:/soa/shared/casemgmt/CaseEvent.xsd").toURI();
                caseActionSchemaURI = new URL("oramds:/soa/shared/casemgmt/CaseAction.xsd").toURI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                result = CaseDictionaryHandler.initCaseRuleDictionary((String)componentDir, (String)componentName, caseDataSchemaURIs, (URI)caseSchemaURI, (URI)caseEventSchemaURI, caseActionSchemaURI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        private void caseRulesStep2(String caseName, Map<CaseDictionaryHandler.DICTIONARY_TYPE, RuleDictionary> dictionaryMap) {
            String compositeName = this.project.getName();
            String projectDir = this.project.getWriter().getProjectFileSystem().getLocalFileSystem().getRootFolder().getAbsolutePath();
            String componentName = caseName + RULES;
            RuleDictionary customRuleDictionary = dictionaryMap.get(CaseDictionaryHandler.DICTIONARY_TYPE.CUSTOM);
            try {
                RulesIntegrationWriter.deleteFilesFromPreviousStep2Run(this.project, caseName, true);
                CaseDictionaryHandler.writeDecsContents((String)compositeName, (String)projectDir, (String)componentName, (RuleDictionary)customRuleDictionary);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void caseRulesStep345(CompositeCaseUtil compositeCaseUtil, String caseName) {
            try {
                compositeCaseUtil.addCaseRulesIntegration(caseName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private Map<CaseDictionaryHandler.DICTIONARY_TYPE, RuleDictionary> regenerateXMLFactTypes(List<String> schemaList, List<String> caseInputXmlTypes) {
            String caseName = this.project.getCase().getName();
            String componentDir = this.project.getWriter().getProjectFileSystem().getLocalFileSystem().getRootFolder().getAbsolutePath();
            if (!componentDir.endsWith("/")) {
                componentDir = componentDir + "/";
            }
            String componentName = caseName + RULES;
            URI caseDataURI = null;
            ArrayList<URI> caseDataURIList = new ArrayList<URI>();
            try {
                for (String path : schemaList) {
                    caseDataURI = path.contains(":") ? new URI(path) : new File(componentDir + path).toURI();
                    caseDataURIList.add(caseDataURI);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Map result = null;
            try {
                result = CaseDictionaryHandler.regenerateXMLFactTypes((String)componentDir, (String)componentName, caseDataURIList, caseInputXmlTypes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    private static class ResourceBundleWriter {
        private ResourceBundleWriter() {
        }

        static void write(Project project, PropertyBundles propertyBundles) throws IOException {
            VFile[] bundlesFiles;
            String bundleName = propertyBundles.getName();
            VFile properties = ProjectCaseLoader.ResourceBundleLoader.getDefaultBundle(project, bundleName);
            VFile folder = properties.getParentFile();
            ProjectFileSystem projectFileSystem = project.getLoader().getProjectFileSystem();
            VFileSystem dataFileSystem = projectFileSystem.getDataFileSystem();
            HashSet<VFile> allSaveFiles = new HashSet<VFile>();
            PropertyBundle root = propertyBundles.getDefault();
            VFile rootFile = dataFileSystem.createFile(folder, bundleName + ".properties");
            ResourceBundleWriter.saveProperties(rootFile, root.createProperties());
            allSaveFiles.add(rootFile);
            Set entries = propertyBundles.entrySet();
            for (Map.Entry entry : entries) {
                Locale locale = (Locale)entry.getKey();
                String name = propertyBundles.getName(locale);
                VFile bundleFile = dataFileSystem.createFile(folder, name + ".properties");
                ResourceBundleWriter.saveProperties(bundleFile, ((PropertyBundle)entry.getValue()).createProperties());
                allSaveFiles.add(bundleFile);
            }
            for (VFile vFile : bundlesFiles = ProjectCaseLoader.ResourceBundleLoader.getBundles(folder, bundleName)) {
                if (allSaveFiles.contains(vFile)) continue;
                vFile.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void saveProperties(VFile file, Properties properties) throws IOException {
            VFileOutputStream os = null;
            try {
                os = new VFileOutputStream(file);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "ISO8859_1");
                properties.store((Writer)writer, null, true);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            StreamUtils.close((Closeable[])new Closeable[]{os});
        }
    }

    private static class OrganizationIntegrationWriter {
        private Project project;
        private ProjectCase projectCase;

        private OrganizationIntegrationWriter(ProjectCase projectCase) {
            this.projectCase = projectCase;
            this.project = projectCase.getProject();
        }

        public static OrganizationIntegrationWriter create(ProjectCase projectCase) {
            return new OrganizationIntegrationWriter(projectCase);
        }

        public void writeOnCaseUpdate() {
            Case casemgmt = this.projectCase.getCase();
            Organization organization = this.project.getOrganization();
            StakeHolders stakeHolders = casemgmt.getStakeHolders();
            for (StakeHolder stakeHolder : stakeHolders) {
                String name = stakeHolder.getName();
                Role role = organization.findRoleById(name);
                if (role != null) continue;
                try {
                    role = organization.createRole(name, name);
                    organization.addChild(role);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

