/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.catalog.composite.CompositeAccessorFactory;
import oracle.bpm.project.interfaces.BuilderException;
import oracle.bpm.project.interfaces.ProcessUtil;
import oracle.bpm.project.interfaces.ProcessWsdlWriter;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.sensor.MeasurementsFileGenerator;
import oracle.bpm.project.io.sensor.ProcessMeasurementsListenersManager;
import oracle.bpm.project.io.serializers.model.ModelFormat;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileGenerator;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ProjectObjectWriterMetadata(objectClasses={Process.class})
public class ProcessWriter
extends AbstractWriter {
    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        VFile processFile = this.getFile(projectObject);
        boolean newProcess = !processFile.exists();
        VFile result = super.write(projectObject);
        try {
            Process process = (Process)projectObject;
            if (!ModelUtils.isDefaultProcess(process)) {
                this.updateComposite(process);
                if (process.isMeasurementsChanged() || newProcess) {
                    MeasurementsFileGenerator measurementsFileGenerator = new MeasurementsFileGenerator(projectObject.getProject());
                    measurementsFileGenerator.generateFile();
                    process.setMeasurementsChanged(false);
                }
                if (newProcess) {
                    ProcessMeasurementsListenersManager.getInstance().startListeningProcessMeasurementsChanges(process);
                }
                DocumentationFileGenerator.generateDocumentationFileFor(process);
            }
        }
        catch (Exception unexpected) {
            Log.logSevere((Throwable)unexpected);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
        Process content = (Process)object;
        ModelFormat format = ModelFormat.Extension.get(SchemaType.PROCESS);
        OutputStreamWriter out = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
        try {
            format.writeXml(content, out);
        }
        catch (Throwable throwable) {
            StreamUtils.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        StreamUtils.close((Closeable[])new Closeable[]{out});
    }

    @Override
    public void delete(@NotNull ProjectObject projectObject) throws ProjectException {
        Process process = (Process)projectObject;
        Project project = process.getProject();
        if (project != null && project.getCase() != null) {
            Collection<ProjectCaseActivity> caseActivities = project.getCase().getCaseActivitiesForProcess(process.getName());
            for (ProjectCaseActivity caseActivity : caseActivities) {
                caseActivity.delete();
            }
        }
        VFile file = this.getFile(process);
        this.delete(file, process);
        if (!ModelUtils.isDefaultProcess(process)) {
            this.deleteProcessArtifacts(process, file);
            MeasurementsFileGenerator measurementsFileGenerator = new MeasurementsFileGenerator(projectObject.getProject());
            if (measurementsFileGenerator.getMeasurementsFile() != null && measurementsFileGenerator.getMeasurementsFile().exists()) {
                measurementsFileGenerator.generateFile();
            }
            VFile docFile = DocumentationFileGenerator.getDocumentationsFile(process);
            this.delete(docFile, process);
        }
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof Process) : "projectObject must be instance of Process";
        Process process = (Process)projectObject;
        VFile folder = this.getContainerFolder(process);
        String extension = SchemaType.getExtensionFor((SchemaType)SchemaType.PROCESS);
        String fileName = process.getId() + extension;
        ProjectWriter writer = projectObject.getProject().getWriter();
        VFileSystem dataFileSystem = writer.getProjectFileSystem().getDataFileSystem();
        return dataFileSystem.createFile(folder, fileName);
    }

    Sequence<Process> findCallers(final @NotNull Process process) {
        assert (process.isCallableSubprocess());
        return CollectionUtils.asSequence(process.getProject().getProcesses()).select((Predicate)new Predicate<Process>(){

            public boolean check(@Nullable Process value) {
                return value != null && !value.isCallableSubprocess() && !ModelUtils.getAllActivities(value).select(ProcessWriter.callersOf(process)).isEmpty();
            }
        });
    }

    private static Predicate<Activity> callersOf(final @NotNull Process process) {
        return new Predicate<Activity>(){

            public boolean check(@Nullable Activity value) {
                return value != null && value.isCallActivity() && value.asAnyNode(CallActivity.class).getCalledElement() == process;
            }
        };
    }

    private void updateComposite(Process process) throws BuilderException {
        if (!CompositeAccessorFactory.isFusionPlatform() && !ProcessUtil.hasCycles((Process)process)) {
            Sequence<Process> callers;
            ProcessWsdlWriter.write((Process)process);
            if (process.getProject() != null) {
                CompositeAccessorFactory.createCompositeUpdater((Process)process).updateComposite();
            }
            if (process.isCallableSubprocess() && (callers = this.findCallers(process)) != null) {
                for (Process caller : callers) {
                    caller.setDirty(true);
                }
            }
        }
    }

    private void deleteProcessArtifacts(Process process, VFile file) throws ProjectException {
        if (!CompositeAccessorFactory.isFusionPlatform()) {
            String artifactName = FileUtils.removeExtension((String)file.getName());
            String wsdlFileName = artifactName + ".wsdl";
            VFile wsdlVFile = file.getFileSystem().createFile(wsdlFileName);
            this.delete(wsdlVFile, process);
            CompositeAccessorFactory.createCompositeUpdater((Process)process).delete();
        }
    }
}

