/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.project.io.fs.ResourceObjectType;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.io.serializers.simulation.model.ModelSimulationJaxbVisitor;
import oracle.bpm.project.io.simulation.jaxb.model.ObjectFactory;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={ModelSimulation.class})
public class ModelSimulationWriter
extends AbstractWriter {
    private static final JAXBContext JAXB_CONTEXT = JaxbHelper.newContext((Class[])new Class[]{ObjectFactory.class});

    @Override
    public void write(ProjectObject projectObject, OutputStream outputStream) throws IOException, ProjectException {
        assert (projectObject instanceof ModelSimulation) : "projectObject must be instance of ModelSimulation";
        ModelSimulationJaxbVisitor jaxbVisitor = ModelSimulationJaxbVisitor.create();
        ModelSimulation modelSimulation = (ModelSimulation)projectObject;
        modelSimulation.visit(jaxbVisitor);
        try {
            JAXBContext jaxbContext = JAXB_CONTEXT;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)jaxbVisitor.getJaxbModelSimulation(), outputStream);
        }
        catch (Exception e) {
            try {
                throw ProjectException.wrap((ProjectObject)modelSimulation, e);
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{outputStream});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{outputStream});
    }

    @Override
    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        assert (projectObject instanceof ModelSimulation) : "projectObject must be instance of ModelSimulation";
        ModelSimulation modelSimulation = (ModelSimulation)projectObject;
        VFile folder = this.getContainerFolder(modelSimulation);
        ResourceObjectType resourceType = ResourceObjectType.getResourceType(modelSimulation);
        String fileName = modelSimulation.getProcess().getId() + "_" + modelSimulation.getId() + resourceType.getFileExtension();
        return projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem().createFile(folder, fileName);
    }
}

