/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.bpm.extensionpoint.metadata.ProjectObjectWriterMetadata;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Literals;
import oracle.bpm.project.io.deploymentdescriptor.model.BpmDeploymentDescriptor;
import oracle.bpm.project.io.deploymentdescriptor.model.Members;
import oracle.bpm.project.io.deploymentdescriptor.model.ObjectFactory;
import oracle.bpm.project.io.deploymentdescriptor.model.OrganizationalUnitMapping;
import oracle.bpm.project.io.deploymentdescriptor.model.Role;
import oracle.bpm.project.io.fs.writer.AbstractWriter;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.deployment.DeploymentDescriptor;
import oracle.bpm.project.model.deployment.RoleMapping;
import oracle.bpm.project.model.deployment.RoleMappings;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Group;
import oracle.bpm.project.model.identity.User;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;
import org.jetbrains.annotations.NotNull;

@ProjectObjectWriterMetadata(objectClasses={DeploymentDescriptor.class})
public class DeploymentDescriptorWriter
extends AbstractWriter {
    private ObjectFactory objectFactory = new ObjectFactory();

    public static VFile getDeploymentDescriptorFile(DeploymentDescriptor deploymentDescriptor) {
        VFileSystem dataFileSystem = deploymentDescriptor.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        return dataFileSystem.createFile(dataFileSystem.getRoot(), "deploymentDescriptor.xml");
    }

    @Override
    public VFile getFile(@NotNull ProjectObject projectObject) throws ProjectException {
        return DeploymentDescriptorWriter.getDeploymentDescriptorFile((DeploymentDescriptor)projectObject);
    }

    @Override
    public void write(ProjectObject projectObject, OutputStream outputStream) throws IOException, ProjectException {
        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)projectObject;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, Literals.DEFAULT_ENCODING);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
            writer.write("<?oracleBPM version=\"" + Id.getAbsoluteVersion() + "\" fileRevision=\"" + "20090901" + "\"?>\n");
            marshaller.marshal((Object)this.visit(deploymentDescriptor), (Writer)writer);
            writer.flush();
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    private BpmDeploymentDescriptor visit(DeploymentDescriptor deploymentDescriptor) {
        BpmDeploymentDescriptor bpmDeploymentDescriptor = this.objectFactory.createBpmDeploymentDescriptor();
        this.addRoleMappings(bpmDeploymentDescriptor, deploymentDescriptor.getRoleMappingsContainer());
        this.addOrganizationalUnitMapping(bpmDeploymentDescriptor, deploymentDescriptor.getOrganizationalUnitMapping());
        return bpmDeploymentDescriptor;
    }

    private void addOrganizationalUnitMapping(BpmDeploymentDescriptor bpmDeploymentDescriptor, oracle.bpm.project.model.deployment.OrganizationalUnitMapping organizationalUnitMapping) {
        OrganizationalUnitRef ouRef = organizationalUnitMapping.getOrganizationalUnitRef();
        if (ouRef != null) {
            OrganizationalUnitMapping tOuMapping = this.objectFactory.createOrganizationalUnitMapping();
            tOuMapping.setOrganizationalUnit(ouRef.getId());
            bpmDeploymentDescriptor.setOrganizationalUnitMapping(tOuMapping);
        }
    }

    private void addRoleMappings(BpmDeploymentDescriptor bpmDeploymentDescriptor, RoleMappings roleMappings) {
        for (RoleMapping roleMapping : roleMappings.getRoleMappings()) {
            Role tRole = this.objectFactory.createRole();
            tRole.setName(roleMapping.getAbstractRole().getId());
            Members members = this.objectFactory.createMembers();
            this.addMembers(members, roleMapping);
            tRole.setMembers(members);
            bpmDeploymentDescriptor.getRole().add(tRole);
        }
    }

    private void addMembers(Members members, RoleMapping roleMapping) {
        this.addUsers(members.getUser(), roleMapping);
        this.addGroups(members.getGroup(), roleMapping);
        this.addApplicationRoles(members.getApplicationRole(), roleMapping);
    }

    private void addUsers(List<oracle.bpm.project.io.deploymentdescriptor.model.User> tUsers, RoleMapping roleMapping) {
        for (User user : roleMapping.getUsers()) {
            oracle.bpm.project.io.deploymentdescriptor.model.User tUser = this.objectFactory.createUser();
            tUser.setName(user.getName());
            tUser.setRealm(user.getRealm());
            tUsers.add(tUser);
        }
    }

    private void addGroups(List<oracle.bpm.project.io.deploymentdescriptor.model.Group> tGroups, RoleMapping roleMapping) {
        for (Group group : roleMapping.getGroups()) {
            oracle.bpm.project.io.deploymentdescriptor.model.Group tGroup = this.objectFactory.createGroup();
            tGroup.setName(group.getName());
            tGroup.setRealm(group.getRealm());
            tGroups.add(tGroup);
        }
    }

    private void addApplicationRoles(List<oracle.bpm.project.io.deploymentdescriptor.model.ApplicationRole> tApplicationRoles, RoleMapping roleMapping) {
        for (ApplicationRole applicationRole : roleMapping.getApplicationRoles()) {
            oracle.bpm.project.io.deploymentdescriptor.model.ApplicationRole tApplicationRole = this.objectFactory.createApplicationRole();
            tApplicationRole.setName(applicationRole.getName());
            tApplicationRole.setApplicationContext(applicationRole.getApplicationContext());
            tApplicationRoles.add(tApplicationRole);
        }
    }
}

