/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.writer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.project.io.fs.ResourceObjectType;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.io.serializers.organization.ProjectObjectWriter;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;

abstract class AbstractWriter
implements ProjectObjectWriter {
    AbstractWriter() {
    }

    @Override
    public boolean canWrite(ProjectObject projectObject) throws ProjectException {
        VFile file = this.getFile(projectObject);
        if (file == null || file.exists()) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VFile write(ProjectObject projectObject) throws ProjectException {
        VFile result;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            this.write(projectObject, buffer);
            result = this.getFile(projectObject);
            result.getParentFile().mkdirs();
            VFileOutputStream out = null;
            try {
                out = new VFileOutputStream(result);
                out.write(buffer.toByteArray());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap(projectObject, e);
        }
        return result;
    }

    @Override
    public void write(ProjectObject object, OutputStream outputStream) throws IOException, ProjectException {
    }

    @Override
    public VFile getFile(@NotNull ProjectObject projectObject) throws ProjectException {
        VFile result = null;
        if (projectObject instanceof Adaptable) {
            result = (VFile)((Adaptable)projectObject).as(VFile.class);
        }
        if (result == null) {
            result = this.createFile(projectObject);
        }
        return result;
    }

    @Override
    public void delete(ProjectObject projectObject) throws ProjectException {
        VFile file = this.getFile(projectObject);
        if (file != null) {
            this.delete(file, projectObject);
        }
    }

    protected static VFile fileToVFile(@NotNull VFileSystem fs, @NotNull File file) throws IOException {
        assert (fs instanceof JavaFileSystem) : "FileSystem must be a JavaFileSystem";
        VFile vFile = null;
        JavaFileSystem jfs = (JavaFileSystem)fs;
        String projectPath = jfs.getFileSystemRoot().getCanonicalPath();
        String processPath = file.getCanonicalPath();
        if (processPath.startsWith(projectPath)) {
            processPath = processPath.substring(projectPath.length()).replace(File.separatorChar, '/');
            vFile = fs.createFile(processPath);
        }
        return vFile;
    }

    protected void delete(@NotNull VFile file, @NotNull ProjectObject projectObjectForException) throws ProjectException {
        try {
            if (file.isDirectory()) {
                if (file.exists() && !VFileUtils.deleteDirectory((VFile)file)) {
                    throw new ProjectException(projectObjectForException, ProjectIoMsg.CANNOT_DELETE_FOLDER(file.getCanonicalPath()));
                }
            } else if (file.exists() && !file.delete()) {
                throw new ProjectException(projectObjectForException, ProjectIoMsg.CANNOT_DELETE_FILE(file.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw ProjectException.wrap(projectObjectForException, e);
        }
    }

    protected VFile createFile(@NotNull ProjectObject projectObject) throws ProjectException {
        VFileSystem fs = projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        if (projectObject instanceof ResourceContainer) {
            return projectObject.getPath().getVFile(fs.getRoot());
        }
        ResourceObjectType resourceType = ResourceObjectType.getResourceType(projectObject);
        VFile folder = this.getContainerFolder(projectObject);
        String fileName = projectObject.getId() + resourceType.getFileExtension();
        return fs.createFile(folder, fileName);
    }

    protected VFile getContainerFolder(ProjectObject projectObject) throws ProjectException {
        VFileSystem fs = projectObject.getProject().getWriter().getProjectFileSystem().getDataFileSystem();
        VFile folder = null;
        for (ProjectObject parent = projectObject.getParentObject(); parent != null; parent = parent.getParentObject()) {
            VFile parentFile;
            if (parent.getPath() == null || (parentFile = parent.getPath().getVFile(fs.getRoot())).exists() && !parentFile.isDirectory()) continue;
            folder = parentFile;
            break;
        }
        assert (folder != null) : "Project object folder container not found: " + projectObject;
        folder.mkdirs();
        return folder;
    }
}

