/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bpm.extensionpoint.metadata.ProjectObjectLoaderMetadata;
import oracle.bpm.holidays.FixedHoliday;
import oracle.bpm.holidays.Holiday;
import oracle.bpm.holidays.HolidayCalendar;
import oracle.bpm.holidays.YearApplicableHoliday;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.WorkDaySchedule;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.project.OrganizationalUnitRefImpl;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.identity.ApplicationRole;
import oracle.bpm.project.model.identity.Group;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberContainer;
import oracle.bpm.project.model.identity.MemberType;
import oracle.bpm.project.model.identity.User;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.OrganizationalChart;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.OrganizationalUnitRef;
import oracle.bpm.project.model.organization.PotentialAssignee;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleEscalation;
import oracle.bpm.project.organization.OrganizationImpl;
import oracle.bpm.project.organization.PotentialAssigneeImpl;
import oracle.bpm.project.organization.RoleEscalationImpl;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociations;
import oracle.bpm.services.organization.model.ApplicationRoleType;
import oracle.bpm.services.organization.model.ApplicationRoles;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.CalendarRules;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayRules;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.OrganizationalUnits;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.ParticipantTypeEnum;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayType;
import oracle.bpm.xmlparser.ParserException;
import org.jetbrains.annotations.NotNull;

@ProjectObjectLoaderMetadata(objectClasses={Organization.class})
public class OrganizationLoader
extends ProjectObjectLoader<Organization> {
    private static JAXBContext jaxbContext;

    @Override
    public Organization create(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        return new OrganizationImpl(this.getProject());
    }

    @Override
    public Organization loadObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        Organization organization = this.create(container, file);
        organization.setId("organization");
        try {
            VFileInputStream is = new VFileInputStream(file);
            this.loadObject(organization, (InputStream)is);
        }
        catch (IOException e) {
            throw ProjectException.wrap((ProjectObject)organization, e);
        }
        return organization;
    }

    @Override
    public Organization loadObject(@NotNull InputStream in) throws ProjectException {
        OrganizationImpl organization = new OrganizationImpl(this.getProject());
        this.loadObject((Organization)organization, in);
        return organization;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadObject(Organization organization, InputStream is) throws ProjectException {
        try {
            JAXBContext jc = jaxbContext;
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            Object unmarshalledObject = unmarshaller.unmarshal(is);
            if (!(unmarshalledObject instanceof oracle.bpm.services.organization.model.Organization)) throw new ParserException("Invalid JAXB element found");
            this.load((oracle.bpm.services.organization.model.Organization)unmarshalledObject, organization);
        }
        catch (ParserException e) {
            try {
                throw ProjectException.wrap((ProjectObject)organization, e);
                catch (JAXBException e2) {
                    throw ProjectException.wrap((ProjectObject)organization, e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{is});
    }

    private void load(oracle.bpm.services.organization.model.Organization tOrganization, Organization organization) throws ProjectException {
        if (tOrganization.isSetUpdateExistingObjects()) {
            organization.setUpdateExistingObject(tOrganization.isUpdateExistingObjects());
        }
        if (tOrganization.isSetApplicationRoles()) {
            this.addRoles(tOrganization.getApplicationRoles(), organization);
        }
        if (tOrganization.isSetOrganizationalUnits()) {
            this.addOrganizationalUnits(tOrganization.getOrganizationalUnits(), organization);
        }
        if (!Str.isEmpty((String)tOrganization.getProcessOrganizationalUnitId())) {
            OrganizationalUnitRefImpl ouMappingRef = new OrganizationalUnitRefImpl(tOrganization.getProcessOrganizationalUnitId(), tOrganization.getProcessOrganizationalUnitName(), organization.getProject());
            organization.getOrganizationalChart().setOrganizationalUnitMapping((OrganizationalUnitRef)ouMappingRef);
        }
        if (tOrganization.isSetHolidayRules()) {
            this.addHolidayRules(tOrganization.getHolidayRules(), organization);
        }
        if (tOrganization.isSetCalendarRules()) {
            this.addCalendarRules(tOrganization.getCalendarRules(), organization);
        }
        if (tOrganization.isSetApplicationRoleOrgUnitCalendarAssociations()) {
            this.addApplicationRoleOrgUnitCalendarAssociation(tOrganization.getApplicationRoleOrgUnitCalendarAssociations(), organization);
        }
        if (tOrganization.isSetParticipantPropertiesList()) {
            this.addParticipantPropertiesList(tOrganization, organization);
        }
    }

    private void addParticipantPropertiesList(oracle.bpm.services.organization.model.Organization tOrganization, Organization organization) throws ProjectException {
        for (ParticipantProperties participantProperties : tOrganization.getParticipantPropertiesList().getParticipantProperties()) {
            PrincipleRefType principleRefType = participantProperties.getParticipant();
            ApplicationRoleType applicationRoleType = this.findApplicationRoleTypeByName(tOrganization, principleRefType.getName());
            String processRoleId = applicationRoleType.getProcessRole().getId();
            Role role = organization.findRoleById(processRoleId);
            for (ParticipantProperty tParticipantProperty : participantProperties.getParticipantProperty()) {
                if (tParticipantProperty.getName().equals("ESCALATIONPATH")) {
                    this.setRoleEscalation(role, tParticipantProperty, tOrganization);
                    continue;
                }
                this.setPotentialAssignee(role, tParticipantProperty, tOrganization);
            }
        }
    }

    private void setPotentialAssignee(Role role, ParticipantProperty tParticipantProperty, oracle.bpm.services.organization.model.Organization tOrganization) throws ProjectException {
        PotentialAssigneeImpl potentialAssignee = new PotentialAssigneeImpl(role.getProject());
        potentialAssignee.setCreatedDate(tParticipantProperty.getCreatedDate().toGregorianCalendar().getTime());
        if (tParticipantProperty.isSetLastUpdatedDate()) {
            potentialAssignee.setLastUpdatedDate(tParticipantProperty.getLastUpdatedDate().toGregorianCalendar().getTime());
        }
        Member member = this.createMember((MemberContainer)potentialAssignee, tParticipantProperty.getValue().iterator().next(), tOrganization);
        potentialAssignee.addMember(member);
        role.setPotentialAssignee((PotentialAssignee)potentialAssignee);
    }

    private void setRoleEscalation(Role role, ParticipantProperty tParticipantProperty, oracle.bpm.services.organization.model.Organization tOrganization) throws ProjectException {
        RoleEscalationImpl roleEscalation = new RoleEscalationImpl(role.getProject());
        roleEscalation.setCreatedDate(tParticipantProperty.getCreatedDate().toGregorianCalendar().getTime());
        if (tParticipantProperty.isSetLastUpdatedDate()) {
            roleEscalation.setLastUpdatedDate(tParticipantProperty.getLastUpdatedDate().toGregorianCalendar().getTime());
        }
        Member member = this.createMember((MemberContainer)roleEscalation, tParticipantProperty.getValue().iterator().next(), tOrganization);
        roleEscalation.addMember(member);
        role.setRoleEscalation((RoleEscalation)roleEscalation);
    }

    private Member createMember(MemberContainer memberContainer, Object participantPropertyValue, oracle.bpm.services.organization.model.Organization tOrganization) {
        String value = (String)participantPropertyValue;
        int index = value.indexOf(":");
        String type = value.substring(0, index);
        String name = value.substring(index + 1, value.length());
        MemberType memberType = MemberType.valueOf(type);
        ApplicationRoleType applicationRoleType = this.findApplicationRoleTypeByName(tOrganization, name);
        String memberRoleName = memberType == MemberType.APPROLE && applicationRoleType != null && !Str.isEmpty((String)applicationRoleType.getProcessRole().getName()) ? applicationRoleType.getProcessRole().getName() : name;
        return memberContainer.createMember(memberType, memberRoleName);
    }

    private ApplicationRoleType findApplicationRoleTypeByName(oracle.bpm.services.organization.model.Organization tOrganization, String name) {
        for (ApplicationRoleType applicationRoleType : tOrganization.getApplicationRoles().getApplicationRole()) {
            if (!applicationRoleType.getName().equals(name)) continue;
            return applicationRoleType;
        }
        return null;
    }

    private void addApplicationRoleOrgUnitCalendarAssociation(ApplicationRoleOrgUnitCalendarAssociations applicationRoleOrgUnitCalendarAssociations, Organization organization) {
        for (ApplicationRoleOrgUnitCalendarAssociation appRoleOUCalendarAssociation : applicationRoleOrgUnitCalendarAssociations.getApplicationRoleOrgUnitCalendarAssociation()) {
            Role role;
            String roleName = appRoleOUCalendarAssociation.getApplicationRole().getName();
            int index = roleName.indexOf(".");
            if (index != -1) {
                roleName = roleName.substring(index + 1);
            }
            if ((role = organization.findRoleById(roleName)) == null) continue;
            CalendarRuleAssignment.Mutable calendarRuleAssignment = role.createCalendarRuleAssignment();
            calendarRuleAssignment.setCalendarRule(appRoleOUCalendarAssociation.getCalendarRuleId());
            calendarRuleAssignment.setCalendarRuleName(appRoleOUCalendarAssociation.getCalendarRuleName());
            calendarRuleAssignment.setOrganizationalUnit(appRoleOUCalendarAssociation.getOrganizationalUnitId());
            calendarRuleAssignment.setOrganizationalUnitName(appRoleOUCalendarAssociation.getOrganizationalUnitName());
            role.addCalendarRuleAssignment(calendarRuleAssignment);
        }
    }

    private void addRoles(ApplicationRoles applicationRoles, Organization organization) throws ProjectException {
        for (ApplicationRoleType applicationRoleType : applicationRoles.getApplicationRole()) {
            String roleName;
            String roleId;
            if (applicationRoleType.getProcessRole() != null) {
                roleId = applicationRoleType.getProcessRole().getId();
                roleName = applicationRoleType.getProcessRole().getName();
            } else {
                roleId = applicationRoleType.getId();
                roleName = applicationRoleType.getName();
            }
            if ("ProcessOwner".equals(roleId) && (!"ProcessOwner".equals(roleId) || organization.findRoleById("ProcessOwner") != null)) continue;
            if (roleId == null && "Process Owner".equals(roleName)) {
                roleId = "ProcessOwner";
            }
            Role role = organization.createRole(roleId == null ? roleName : roleId, roleName);
            role.setName(roleName);
            if (applicationRoleType.getProcessRole() != null && applicationRoleType.getName().equals(applicationRoleType.getProcessRole().getId())) {
                role.setShared(true);
            }
            List members = applicationRoleType.getMember();
            for (PrincipleRefType principleRefType : members) {
                Member member = this.createMember(role, principleRefType);
                role.addMember(member);
            }
            organization.addChild(role);
        }
        if (organization.findChild(Role.class, "ProcessOwner") == null) {
            Role processOwnerRole = organization.createRole("ProcessOwner", "Process Owner");
            organization.addChild(processOwnerRole);
        }
    }

    private void addOrganizationalUnits(OrganizationalUnits tOrganizationalUnits, Organization organization) throws ProjectException {
        OrganizationalChart organizationalChart = organization.getOrganizationalChart();
        for (OrganizationalUnit tOu : tOrganizationalUnits.getOrganizationalUnit()) {
            oracle.bpm.project.model.organization.OrganizationalUnit ouParent = null;
            if (tOu.getParentOrganizationalUnitId() != null) {
                ouParent = this.findOrCreate(tOu.getParentOrganizationalUnitId(), tOrganizationalUnits.getOrganizationalUnit(), organization);
            }
            OrganizationalUnit.Mutable ou = organizationalChart.createOrganizationalUnit(tOu.getOrganizationalUnitId(), ouParent).asMutable();
            ou.setName(tOu.getOrganizationalUnitName());
            ou.setDescription(tOu.getDescription());
            for (oracle.bpm.services.organization.model.MemberType tMemberType : tOu.getMember()) {
                Member member = this.createMember(ou, (PrincipleRefType)tMemberType);
                ou.addMember(member);
            }
            if (tOu.getCalendarRuleId() != null) {
                ou.setCalendarRule(tOu.getCalendarRuleId());
            }
            organizationalChart.addChild(ou);
        }
    }

    private oracle.bpm.project.model.organization.OrganizationalUnit findOrCreate(String parentOrganizationalUnitId, List<OrganizationalUnit> tOrganizationalUnits, Organization organization) {
        oracle.bpm.project.model.organization.OrganizationalUnit organizationalUnit = organization.findOrganizationalUnit(parentOrganizationalUnitId);
        if (organizationalUnit == null) {
            for (OrganizationalUnit unit : tOrganizationalUnits) {
                if (!unit.getOrganizationalUnitId().equals(parentOrganizationalUnitId)) continue;
                organizationalUnit = this.findOrCreate(unit.getOrganizationalUnitId(), tOrganizationalUnits, organization);
            }
        }
        return organizationalUnit;
    }

    private Member createMember(MemberContainer memberContainer, PrincipleRefType principleRefType) throws ProjectException {
        ParticipantTypeEnum type = principleRefType.getType();
        if (type == ParticipantTypeEnum.USER) {
            User user = memberContainer.createUser(principleRefType.getName());
            user.setName(principleRefType.getName());
            user.setRealm(principleRefType.getRealm());
            return user;
        }
        if (type == ParticipantTypeEnum.GROUP) {
            Group group = memberContainer.createGroup(principleRefType.getName());
            group.setName(principleRefType.getName());
            group.setRealm(principleRefType.getRealm());
            return group;
        }
        ApplicationRole applicationRole = memberContainer.createApplicationRole(principleRefType.getName());
        applicationRole.setName(principleRefType.getName());
        applicationRole.setApplicationContext(principleRefType.getApplicationContext());
        return applicationRole;
    }

    private void addHolidayRules(HolidayRules tHolidayRules, Organization organization) throws ProjectException {
        for (HolidayRule tHr : tHolidayRules.getHolidayRule()) {
            HolidayRule.Mutable holidayRule = organization.createHolidayRule(tHr.getId()).asMutable();
            Holiday[] holidays = new Holiday[tHr.getHolidays().size()];
            int i = 0;
            for (HolidayType tHolidayType : tHr.getHolidays()) {
                Holiday holiday;
                oracle.bpm.holidays.HolidayType holidayType = oracle.bpm.holidays.HolidayType.fromValue((String)tHolidayType.getHolidayPattern().value());
                Time time = Time.valueOf((Date)tHolidayType.getHolidayDate().toGregorianCalendar().getTime());
                holidays[i] = holiday = holidayType == oracle.bpm.holidays.HolidayType.YEAR_APPLICABLE ? YearApplicableHoliday.valueOf((Time)time, (String)tHolidayType.getName()) : FixedHoliday.valueOf((int)time.getDay(), (Month)Month.valueOf((int)time.getMonth()), (String)tHolidayType.getName());
                ++i;
            }
            holidayRule.setName(tHr.getName());
            holidayRule.setHolidayCalendar(new HolidayCalendar(holidays));
            organization.addChild(holidayRule);
        }
    }

    private void addCalendarRules(CalendarRules tCalendarRules, Organization organization) throws ProjectException {
        for (CalendarRule tCalendarRule : tCalendarRules.getCalendarRule()) {
            CalendarRule.Mutable calendarRule = organization.createCalendarRule(tCalendarRule.getId()).asMutable();
            calendarRule.setTimeZone(tCalendarRule.getTimeZone());
            if (tCalendarRule.getHolidayRuleId() != null) {
                calendarRule.setHolidayRule(tCalendarRule.getHolidayRuleId());
            }
            WorkWeek workWeek = new WorkWeek();
            for (WorkdayType tWorkday : tCalendarRule.getWorkdayList().getWorkday()) {
                Day day = Day.valueOf((String)tWorkday.getWeekDay().toString());
                WorkDaySchedule workDaySchedule = new WorkDaySchedule();
                int i = 0;
                for (WorkPeriodType tWorkPeriod : tWorkday.getWorkPeriod()) {
                    XMLGregorianCalendar startCalendar = tWorkPeriod.getStartTime();
                    XMLGregorianCalendar endCalendar = tWorkPeriod.getEndTime();
                    int startTime = startCalendar.getHour() * 100 + startCalendar.getMinute();
                    int endTime = endCalendar.getHour() * 100 + endCalendar.getMinute();
                    workDaySchedule.setShift(i, startTime, endTime);
                    ++i;
                }
                workWeek.setSchedule(day, workDaySchedule);
            }
            calendarRule.setName(tCalendarRule.getName());
            calendarRule.setWorkWeek(workWeek);
            organization.addChild(calendarRule);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

