/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.export;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.io.ProjectAlreadyExistsException;
import oracle.bpm.project.io.UnzipListener;
import oracle.bpm.project.io.fs.InvalidExportFileException;
import oracle.bpm.project.io.fs.msg.ProjectIoMsg;
import oracle.bpm.project.io.fs.util.ProjectFileUtils;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import org.jetbrains.annotations.NotNull;

public class ProjectZipper {
    private ProjectZipper() {
    }

    public static ProjectZipper create() {
        return new ProjectZipper();
    }

    public List<Entry> getEntries(File zipFile) throws InvalidExportFileException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try {
            List<String> projectList = ProjectZipper.getZipEntryName(zipFile);
            for (String projectName : projectList) {
                entries.add(new Entry(projectName, ProjectZipper.normalizeProjectName(projectName)));
            }
        }
        catch (IOException e) {
            throw new InvalidExportFileException();
        }
        return entries;
    }

    public void zipProject(Project projectToZip, @NotNull OutputStream outputStream, UnzipListener unzipListener) throws IOException {
        this.zipProject(projectToZip, outputStream, unzipListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void zipProject(Project projectToZip, @NotNull OutputStream outputStream, UnzipListener unzipListener, VFileFilter filter) throws IOException {
        ZipOutputStream zip;
        block6: {
            zip = null;
            ArrayList<Project> projects = new ArrayList<Project>();
            projects.add(projectToZip);
            try {
                zip = new ZipOutputStream(outputStream);
                for (Project project : projects) {
                    ProjectLoader loader = project.getLoader();
                    assert (loader != null);
                    VFileSystem fs = loader.getProjectFileSystem().getDataFileSystem();
                    VFile root = fs.getRoot();
                    VFile[] files = root.listFiles(filter);
                    System.out.println("root= " + root.getCanonicalPath());
                    for (VFile file : files) {
                        this.addZipEntry(zip, project.getName(), file, filter, unzipListener);
                    }
                }
                if (zip == null) break block6;
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    zip.finish();
                }
                StreamUtils.close((Closeable[])new Closeable[]{zip, outputStream});
                throw throwable;
            }
            zip.finish();
        }
        StreamUtils.close((Closeable[])new Closeable[]{zip, outputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipProject(Project projectToZip, File zipFile, boolean includeDependencies, UnzipListener unzipListener) throws IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(zipFile);
            this.zipProject(projectToZip, fout, unzipListener);
        }
        catch (Throwable throwable) {
            StreamUtils.close((Closeable[])new Closeable[]{fout});
            throw throwable;
        }
        StreamUtils.close((Closeable[])new Closeable[]{fout});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<File> unzipAllProjects(File sourceZippedFile, File destinationDir, boolean force) throws ProjectAlreadyExistsException {
        ArrayList<File> unzipedProjects = new ArrayList<File>();
        FileInputStream fin = null;
        ZipInputStream zip = null;
        try {
            fin = new FileInputStream(sourceZippedFile);
            zip = new ZipInputStream(fin);
            List<String> projects = ProjectZipper.getZipEntryName(sourceZippedFile);
            for (String project : projects) {
                File unzipedProject = this.unzipProject(sourceZippedFile, destinationDir, force, null, project, project);
                unzipedProjects.add(unzipedProject);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            StreamUtils.close((Closeable[])new Closeable[]{fin, zip});
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    StreamUtils.close((Closeable[])new Closeable[]{fin, zip});
                    throw throwable;
                }
            }
            StreamUtils.close((Closeable[])new Closeable[]{fin, zip});
        }
        StreamUtils.close((Closeable[])new Closeable[]{fin, zip});
        return unzipedProjects;
    }

    public Collection<File> unzipProjects(File zippedFile, File destinationDir, boolean force, UnzipListener unzipListener, Map<String, String> projectsName) throws ProjectAlreadyExistsException {
        ArrayList<File> projectFiles = new ArrayList<File>();
        for (String directoryProjectName : projectsName.keySet()) {
            projectFiles.add(this.unzipProject(zippedFile, destinationDir, force, unzipListener, directoryProjectName, projectsName.get(directoryProjectName)));
        }
        return projectFiles;
    }

    /*
     * Exception decompiling
     */
    public File unzipProject(File zippedFile, File destinationDir, boolean force, UnzipListener unzipListener, String zipEntryName, String newProjectName) throws ProjectAlreadyExistsException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getZipEntryName(File zippedFile) throws IOException {
        ArrayList<String> projectsNames = new ArrayList<String>();
        FileInputStream fin = null;
        ZipInputStream zip = null;
        try {
            fin = new FileInputStream(zippedFile);
            zip = new ZipInputStream(fin);
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                String previousName = ProjectFileUtils.getPath(zipEntry).getFirst();
                projectsNames.add(previousName);
                while (zipEntry != null && previousName.equals(ProjectFileUtils.getPath(zipEntry).getFirst())) {
                    zipEntry = zip.getNextEntry();
                }
            }
        }
        catch (Throwable throwable) {
            StreamUtils.close((Closeable[])new Closeable[]{fin, zip});
            throw throwable;
        }
        StreamUtils.close((Closeable[])new Closeable[]{fin, zip});
        return projectsNames;
    }

    private static String normalizeProjectName(String projectName) {
        String result = projectName;
        if (projectName.toLowerCase().endsWith(".fpr") && projectName.length() > ".fpr".length()) {
            result = projectName.substring(0, projectName.length() - ".fpr".length());
        }
        return result;
    }

    private static ZipEntry findFirstEntry(ZipInputStream zip, String name) throws IOException {
        ZipEntry entry = zip.getNextEntry();
        while (entry != null && !ProjectFileUtils.getPath(entry).getFirst().equals(name)) {
            entry = zip.getNextEntry();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addZipEntry(ZipOutputStream zip, String projectName, VFile file, VFileFilter exportFilter, UnzipListener listener) throws IOException {
        if (file.isDirectory()) {
            VFile[] files;
            zip.putNextEntry(new ZipEntry(projectName + file.getCanonicalPath() + "/"));
            for (VFile file2 : files = file.listFiles(exportFilter)) {
                this.addZipEntry(zip, projectName, file2, exportFilter, listener);
            }
        } else {
            zip.putNextEntry(new ZipEntry(projectName + file.getCanonicalPath()));
            if (listener != null) {
                listener.info(ProjectIoMsg.ADDING_FILE(file.getCanonicalPath()).toString());
            }
            VFileInputStream istream = new VFileInputStream(file);
            try {
                StreamUtils.copy((InputStream)istream, (OutputStream)zip);
            }
            finally {
                istream.close();
            }
        }
    }

    public static class Entry {
        private String projectName;
        private String zipEntryName;

        Entry(String zipEntryName, String projectName) {
            this.zipEntryName = zipEntryName;
            this.projectName = projectName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getZipEntryName() {
            return this.zipEntryName;
        }

        public void setProjectName(String projectNamee) {
            this.projectName = projectNamee;
        }
    }
}

