/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractOrganizationChangeManager;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.util.FileUtils;

public class OrganizationalUnitChangeManager
extends AbstractOrganizationChangeManager {
    private OrganizationalUnitChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static OrganizationalUnitChangeManager create(AbstractProjectRepository repository, Project project) {
        return new OrganizationalUnitChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resource) {
        return resource.isFile() && ".xoudl".equals("." + FileUtils.getExtension((File)resource));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        OrganizationalUnit ou = (OrganizationalUnit)projectObject;
        if (this.getOrganization().findOrganizationalUnit(ou.getId()) == null) {
            super.getOrganization().addOrganizationalObject(ou);
        }
        return false;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.OU;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        return super.getOrganization().findOrganizationalUnit(this.getOrganizationalUnitId(resourceFile));
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }

    private String getOrganizationalUnitId(File resourceFile) {
        String iResourcePath = new File(resourceFile.getParentFile(), FileUtils.getName((File)resourceFile)).getAbsolutePath();
        String ouInternalPath = iResourcePath.substring(iResourcePath.indexOf(Path.ORGANIZATIONAL_UNIT.getName()) + Path.ORGANIZATIONAL_UNIT.getName().length() + 1);
        return ouInternalPath;
    }
}

