/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs.events;

import java.io.File;
import java.util.Collection;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.events.AbstractSimulationChangeManager;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.util.FileUtils;

public class ModelSimulationChangeManager
extends AbstractSimulationChangeManager {
    private ModelSimulationChangeManager(AbstractProjectRepository repository, Project project) {
        super(repository, project);
    }

    public static ModelSimulationChangeManager create(AbstractProjectRepository repository, Project project) {
        return new ModelSimulationChangeManager(repository, project);
    }

    @Override
    public boolean isValid(File resourceFile) {
        return resourceFile.isFile() && ".xsim".equals(FileUtils.getExtension((File)resourceFile));
    }

    @Override
    protected boolean addProjectObject(ProjectObject projectObject) throws ProjectException {
        ModelSimulation modelSimulation = (ModelSimulation)projectObject;
        Process model = modelSimulation.getProcess();
        assert (model != null) : "Model cannot be null.";
        model.getProject().getSimulations().addModelSimulation(model.getId(), modelSimulation);
        return false;
    }

    @Override
    protected ProjectObject getProjectObject(File resourceFile) {
        ModelSimulation modelSimulation = null;
        Collection processes = super.getProject().getProcesses();
        for (Process process : processes) {
            String fullName = FileUtils.getName((File)resourceFile);
            String simulationId = fullName.substring(fullName.lastIndexOf("_") + 1);
            modelSimulation = this.getProject().getSimulations().findModelSimulation(process, simulationId);
            if (modelSimulation == null) continue;
            break;
        }
        return modelSimulation;
    }

    @Override
    protected ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL_SIMULATION;
    }

    @Override
    protected boolean replaceProjectObject(ProjectObject projectObject) throws ProjectException {
        super.getProject().replace(projectObject);
        return false;
    }
}

