/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.resources.Resource;

public enum ResourceObjectType {
    EXTERNAL_VARIABLE(".xevdl"),
    BUSINESS_VARIABLE(".xbvdl"),
    BUSINESS_PARAMETER(".xbpdl"),
    ROLE(".xrdl"),
    OU(".xoudl"),
    CALENDAR_RULE(".xcadl"),
    HOLIDAY_RULE(".xhdl"),
    GROUP(".xgdl"),
    PARTICIPANT(".xpadl"),
    PRESENTATION(".xprdl"),
    MODEL(".xpdl"),
    PROJECT_SIMULATION(".xpsi"),
    PROCESS_SIMULATION(".xsim"),
    EXTERNAL_RESOURCE(".xml"),
    LAYOUT(".lyt"),
    PROJECT_PREFERENCES(".xml"),
    ORGANIZATIONAL_CHART(".xocdl"),
    FORM(".form"),
    PROJECT_RESOURCE,
    ORGANIZATION,
    PROJECT_OBJECT_CONTAINER;

    private String fileExtension;

    private ResourceObjectType(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    private ResourceObjectType() {
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public static ResourceObjectType getResourceType(ProjectObject projectObject) {
        ResourceObjectType result = null;
        ProjectObjectType projectObjectType = projectObject.getProjectObjectType();
        switch (projectObjectType) {
            case EXTERNAL_VARIABLE: {
                result = EXTERNAL_VARIABLE;
                break;
            }
            case BUSINESS_VARIABLE: {
                result = BUSINESS_VARIABLE;
                break;
            }
            case BUSINESS_PARAMETER: {
                result = BUSINESS_PARAMETER;
                break;
            }
            case ORGANIZATION_ROLE: {
                result = ROLE;
                break;
            }
            case OU: {
                result = OU;
                break;
            }
            case CALENDAR_RULE: {
                result = CALENDAR_RULE;
                break;
            }
            case HOLIDAY_RULE: {
                result = HOLIDAY_RULE;
                break;
            }
            case ORGANIZATION_GROUP: {
                result = GROUP;
                break;
            }
            case PARTICIPANT: {
                result = PARTICIPANT;
                break;
            }
            case PRESENTATION: {
                result = PRESENTATION;
                break;
            }
            case PROJECT_SIMULATION: {
                result = PROJECT_SIMULATION;
                break;
            }
            case MODEL_SIMULATION: {
                result = PROCESS_SIMULATION;
                break;
            }
            case MODEL: {
                result = MODEL;
                break;
            }
            case EXTERNAL_RESOURCE: {
                result = EXTERNAL_RESOURCE;
                break;
            }
            case LAYOUT: {
                result = LAYOUT;
                break;
            }
            case PROJECT_PREFERENCES: {
                result = PROJECT_PREFERENCES;
                break;
            }
            case ORGANIZATIONAL_CHART: {
                result = ORGANIZATIONAL_CHART;
                break;
            }
            case ORGANIZATION: {
                result = ORGANIZATION;
                break;
            }
            case PROJECT_OBJECT_CONTAINER: {
                result = PROJECT_OBJECT_CONTAINER;
                break;
            }
            case PROJECT_RESOURCE: {
                result = PROJECT_RESOURCE;
                result.fileExtension = ((Resource)projectObject).getType().getFileExtension();
                break;
            }
            case FORM: {
                result = FORM;
            }
        }
        return result;
    }
}

