/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io.fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.project.io.fs.ProjectFilesCache;
import oracle.bpm.project.io.fs.loader.ProjectObjectLoader;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectObjectsCache {
    private Map<VFile, ProjectObject> fileObjects = new HashMap<VFile, ProjectObject>();
    private Map<Class<? extends ProjectObject>, ProjectObjectLoader> loaders = new HashMap<Class<? extends ProjectObject>, ProjectObjectLoader>();
    private Map<Class<? extends ProjectObject>, HashMap<String, ProjectObject>> objects = new HashMap<Class<? extends ProjectObject>, HashMap<String, ProjectObject>>();
    private Project project;
    private ProjectFilesCache projectFilesCache;

    ProjectObjectsCache(@NotNull VFileSystem projectFileSystem, @NotNull Project project) throws IOException {
        this.project = project;
        this.projectFilesCache = new ProjectFilesCache(projectFileSystem);
    }

    public void dispose() {
        this.loaders.clear();
        this.objects.clear();
        this.fileObjects.clear();
        this.projectFilesCache.clear();
    }

    public <P extends ProjectObject> List<P> getAllObjects(@NotNull Class<P> objectClass) throws ProjectException {
        return this.getChildrenByTypeRecursive(this.getProject(), objectClass);
    }

    public <P extends ProjectObject> P getObject(@NotNull ResourceContainer container, @NotNull Class<P> objectClass, @NotNull String id) throws ProjectException {
        this.getChildrenByType(container, objectClass);
        ProjectObject result = this.searchObject(objectClass, id);
        if (result != null) {
            result = this.checkObjectExistence(result);
        }
        return (P)result;
    }

    public <P extends ProjectObject> P reloadObject(P object) throws ProjectException {
        assert (object instanceof ResourceObject) : "Project Object must be a ResourceObject in order to reload it";
        assert (object.getParentObject() instanceof ResourceContainer) : "Parent object must be a ResourceContainer in order to reload an object";
        ProjectObject result = null;
        VFile file = ProjectObjectsCache.getRelatedVFile(object);
        if (file != null) {
            result = this.loadAndCacheObject(object.getRawClass(), (ResourceContainer)object.getParentObject(), file);
        }
        return (P)result;
    }

    public List<ProjectObject> getChildren(@NotNull ResourceContainer container) throws ProjectException {
        return this.getChildrenByTypeGeneric(container, null);
    }

    public <P extends ProjectObject> List<P> getChildrenByType(@NotNull ResourceContainer container, Class<P> objectClass) throws ProjectException {
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        for (ProjectObject child : this.getChildrenByTypeGeneric(container, objectClass)) {
            result.add(child);
        }
        return result;
    }

    public List<VFile> getAllFiles(@NotNull Class<? extends ProjectObject> objectClass) throws ProjectException {
        return this.projectFilesCache.getFiles(objectClass);
    }

    public void resync(VFile file) throws IOException {
        ArrayList<VFile> added = new ArrayList<VFile>();
        ArrayList<VFile> removed = new ArrayList<VFile>();
        this.projectFilesCache.resyncFiles(file, added, removed);
        block0: for (VFile vFile : removed) {
            ProjectObject projectObject = this.fileObjects.remove(vFile);
            if (projectObject == null) continue;
            Class<? extends ProjectObject> rawClass = projectObject.getRawClass();
            HashMap<String, ProjectObject> list = this.objects.get(rawClass);
            for (Map.Entry<String, ProjectObject> entry : list.entrySet()) {
                if (entry.getValue() != projectObject) continue;
                list.remove(entry.getKey());
                continue block0;
            }
        }
    }

    public ProjectObject getObject(VFile file) {
        return this.fileObjects.get(file);
    }

    void addObjectToCache(@NotNull VFile file, @NotNull ProjectObject object, Class<? extends ProjectObject> objectClass) {
        HashMap<String, ProjectObject> newObjectList = this.objects.containsKey(objectClass) ? this.objects.get(objectClass) : new HashMap<String, ProjectObject>();
        newObjectList.put(object.getId(), object);
        this.objects.put(objectClass, newObjectList);
        this.fileObjects.put(file, object);
    }

    @Nullable
    private static VFile getRelatedVFile(@NotNull ProjectObject container) {
        return container instanceof Adaptable ? (VFile)((Adaptable)container).as(VFile.class) : null;
    }

    private Project getProject() {
        return this.project;
    }

    private <P extends ProjectObject> P checkObjectExistence(P object) {
        VFile file = ProjectObjectsCache.getRelatedVFile(object);
        assert (file != null) : "Project Object must have a related VFile";
        if (this.projectFilesCache.exists(file)) {
            return object;
        }
        this.removeObjectFromCache(file, object, object.getRawClass());
        return null;
    }

    private <P extends ProjectObject> List<P> getChildrenByTypeRecursive(@NotNull ResourceContainer container, @NotNull Class<P> objectClass) throws ProjectException {
        List<P> result = this.getChildrenByType(container, objectClass);
        List<FolderContainer> folders = this.getChildrenByType(container, FolderContainer.class);
        for (FolderContainer folder : folders) {
            result.addAll(this.getChildrenByTypeRecursive(folder, objectClass));
        }
        return result;
    }

    private List<ProjectObject> getChildrenByTypeGeneric(@NotNull ResourceContainer container, Class<? extends ProjectObject> objectClass) throws ProjectException {
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        VFile file = ProjectObjectsCache.getRelatedVFile(container);
        if (file != null) {
            List<VFile> children = this.projectFilesCache.getChildrenFiles(file);
            for (VFile child : children) {
                if (objectClass != null && (this.projectFilesCache.getFileClass(child) == null || !objectClass.isAssignableFrom(this.projectFilesCache.getFileClass(child)))) continue;
                ProjectObject childObject = this.getObject(container, child);
                result.add(childObject);
            }
        }
        return result;
    }

    private ProjectObject getObject(@NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        ProjectObject result = this.fileObjects.get(file);
        if (result == null) {
            Class<? extends ProjectObject> objectClass = this.projectFilesCache.getFileClass(file);
            result = this.loadAndCacheObject(objectClass, container, file);
        }
        return result;
    }

    private ProjectObject searchObject(@NotNull Class<? extends ProjectObject> objectClass, @NotNull String id) {
        return this.objects.containsKey(objectClass) && this.objects.get(objectClass).containsKey(id) ? this.objects.get(objectClass).get(id) : null;
    }

    private ProjectObject loadAndCacheObject(@NotNull Class<? extends ProjectObject> objectClass, @NotNull ResourceContainer container, @NotNull VFile file) throws ProjectException {
        ProjectObjectLoader loader = this.getProjectLoader(objectClass);
        assert (loader != null) : "Loader not found for the given Class: " + objectClass.getName();
        Object object = loader.load(this.getProject(), container, file);
        this.addObjectToCache(file, (ProjectObject)object, objectClass);
        return object;
    }

    private void removeObjectFromCache(@NotNull VFile file, @NotNull ProjectObject object, Class<? extends ProjectObject> objectClass) {
        HashMap newObjectList = this.objects.containsKey(objectClass) ? this.objects.get(objectClass) : new HashMap();
        newObjectList.remove(object.getId());
        this.objects.put(objectClass, newObjectList);
        this.fileObjects.remove(file);
    }

    private ProjectObjectLoader getProjectLoader(@NotNull Class<? extends ProjectObject> objectClass) {
        if (this.loaders.containsKey(objectClass)) {
            return this.loaders.get(objectClass);
        }
        ProjectObjectLoader loader = ProjectObjectLoader.create(objectClass, this.getProject());
        this.loaders.put(objectClass, loader);
        return loader;
    }
}

