/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.project.io.fs.util.ProjectFileUtils;

public class FileSystemTokens {
    public static final String PROCESS_EXTENSION = ".xpdl";
    public static final String BPMN_PROCESS_EXTENSION = ".bpmn";
    public static final String WSBPEL_PROCESS_EXTENSION = ".bpel";
    public static final String CASE_EXTENSION = ".case";
    public static final String CASE_ACTIVITY_EXTENSION = ".caseactivity";
    public static final String BPMOBJECT_EXTENSION = ".wsdl";
    public static final String PROJECT_SIMULATION_EXTENSION = ".xpsi";
    public static final String PROCESS_SIMULATION_EXTENSION = ".xsim";
    public static final String OLD_PROJECT_EXTENSION = ".fpr";
    public static final String PUBLICATION_FILE = "publication.xml";
    public static final String ENGINE_FILE = "engine.xml";
    public static final String BAM_FILE = "bam.xml";
    public static final String ORGANIZATION_FILE = "organization.xml";
    public static final String OLD_PROJECT_PREFERENCES_FILE = "projectPreferences";
    public static final String COMPONENT_EXTENSION = ".xcdl";
    public static final String COMPONENT_TYPE_EXTENSION = ".componentType";
    public static final String PRESENTATIONS_DIR = "presentations";
    public static final String EXTERNAL_VARIABLE_EXT = ".xevdl";
    public static final String BUSINESS_VARIABLE_EXT = ".xbvdl";
    public static final String BUSINESS_PARAMETER_EXT = ".xbpdl";
    public static final String ROLE_EXT = ".xrdl";
    public static final String OU_EXT = ".xoudl";
    public static final String CALENDAR_RULE_EXT = ".xcadl";
    public static final String HOLIDAY_RULE_EXT = ".xhdl";
    public static final String GROUP_EXT = ".xgdl";
    public static final String PARTICIPANT_EXT = ".xpadl";
    public static final String PRESENTATION_EXT = ".xprdl";
    public static final String REFERRAL_EXT = ".xml";
    public static final String EXTERNAL_RESOURCE_EXT = ".xml";
    public static final String XSL_TRANSFORMATION_EXT = ".xsl";
    public static final String WSDL_EXTENSION = ".wsdl";
    public static final String FORM_EXTENSION = ".form";
    public static final String ACTIVITY_GUIDE_EXTENSION = ".agdl";
    public static final String ORGANIZATIONAL_CHART_EXT = ".xocdl";
    public static final String EXPORTED_PROJECT_EXT = ".exp";
    public static final String PROJECT_CONFIG_FILE = "configurations.xml";
    public static final String PROJECT_ORGANIZATION_FILE = "organization.xml";
    public static final String PROJECT_PORTAL_VIEWS_FILE = "views.xml";
    public static final String PROJECT_ENGINE_FILE = "engine.xml";
    public static final String PROJECT_PRESENTATIONS_PREFERENCES_FILE = "presentationsPreferences.xml";
    public static final String PROJECT_BAM_FILE = "bam.xml";
    public static final String PROJECT_PROCESSES_ROOT_NODE_NAME = "processes";
    public static final String FILE_SEPARATOR = "/";
    public static final String CONFLICT_FILE = "cvsconflict";
    public static final String USER_PROJECT_FOLDER = "bpmProjects";
    public static final String PROJECT_OBJECT = "fuego.project.object";
    public static final String PRESENTATION_PREFERENCES_FILE = "presentationPreferences.xml";
    public static final String XDML_EXTENSION = ".xdml";
    public static final String XML_EXTENSION = ".xml";
    public static final String JAR_EXTENSION = ".jar";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String WIDGET_EXTENSION = ".xwdl";
    public static final String LAYOUT_EXTENSION = ".lyt";
    public static final String CVS_FILE = "CVS";
    public static final String CVS_IGNORE_FILE = ".cvsignore";
    public static final String SVN_FILE = ".svn";
    public static final String CSS_EXTENSION = ".css";
    public static final String PROPERTIES_EXTENSION = ".properties";
    public static final String DEPLOYMENT_DESCRIPTOR_FILE = "deploymentDescriptor.xml";
    public static final String PROJECT_PREFERENCES_FILE_NAME = "preferences";
    public static final String PROJECT_PREFERENCES_EXTENSION = ".xml";
    public static final String PROJECT_PREFERENCES_FILE = "preferences.xml";
    public static int MAX_FILE_NAME_LENGTH = 128;
    public static final Collection<String> ORGANIZATION_EXTENSIONS = CollectionFactory.createCollectionWith((Object[])new String[]{".xoudl", ".xrdl", ".xgdl", ".xpadl", ".xhdl", ".xcadl", ".xbpdl", ".xbvdl", ".xevdl", ".xprdl"});
    public static final FileFilter componentFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(FileSystemTokens.COMPONENT_EXTENSION);
        }
    };
    public static final FileFilter processFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(FileSystemTokens.PROCESS_EXTENSION);
        }
    };

    private FileSystemTokens() {
    }

    public static File getDefaultProjectsDir() {
        return new File(System.getProperty("user.home") + File.separator + USER_PROJECT_FOLDER);
    }

    public static File getTempProjectsDir() {
        return new File(System.getProperty("java.io.tmpdir") + File.separator + USER_PROJECT_FOLDER);
    }

    public static boolean isValidProject(File projectFile) {
        return projectFile.isDirectory() && (ProjectFileUtils.isFuego60Project(projectFile) || ProjectFileUtils.isFuegoProjectByExtension(projectFile) || ProjectFileUtils.isBPMNProject(projectFile));
    }
}

