/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.xml.namespace.QName;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseData;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.casemgmt.model.cm.NamespacePrefixes;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.expressionbuilders.Variable;
import oracle.tip.tools.ide.common.expressionbuilders.VariableExpressionBuilder;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolverImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathExpressionBuilderDialog
extends VariableExpressionBuilder {
    public XPathExpressionBuilderDialog(@NotNull JFrame parent, @NotNull List<Variable> variables, @Nullable String expression, @NotNull MapperNSResolver namespaceResolver) {
        super(parent, variables, expression, namespaceResolver);
    }

    public static XPathExpressionBuilderDialog create(@NotNull JFrame parent, @NotNull Project project, @NotNull Case ca, @Nullable String expression) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        Variable variable = XPathExpressionBuilderDialog.createCaseVariable(project);
        if (variable != null) {
            vars.add(variable);
        }
        URL projectURL = URLFileSystem.getParent((URL)project.getURL());
        for (Data data : (CaseData)ca.getCaseData().get(0)) {
            String varName = data.getName();
            DataType dataType = data.getDataType();
            URL schemaURL = null;
            if (dataType != DataType.SIMPLE_TYPE) {
                String dataSchema = data.getSchema();
                schemaURL = URLFactory.newURL((URL)projectURL, (String)dataSchema);
            }
            String typeString = data.getType();
            QName type = QName.valueOf(typeString);
            int variableType = dataType == DataType.SIMPLE_TYPE || dataType == DataType.COMPLEX_TYPE ? 3 : 2;
            Variable var = new Variable(varName, variableType, type, 2, schemaURL);
            vars.add(var);
        }
        MapperNSResolverImpl namespaceResolver = new MapperNSResolverImpl();
        NamespacePrefixes prefixes = ca.getNamespacePrefixes();
        for (Map.Entry entry : prefixes.entrySet()) {
            namespaceResolver.addNSEntry((String)entry.getKey(), (String)entry.getValue());
        }
        return new XPathExpressionBuilderDialog(parent, vars, expression, (MapperNSResolver)namespaceResolver);
    }

    public void updateCasePrefixes(@NotNull Case cm) {
        String[][] entries;
        MapperNSResolver resolver = this.getNamespaceResolver();
        NamespacePrefixes prefixes = cm.getNamespacePrefixes();
        prefixes.clear();
        for (String[] entry : entries = resolver.getAllNSEntries()) {
            if (entry.length != 2) continue;
            prefixes.put((Object)entry[0], (Object)entry[1]);
        }
    }

    private static Variable createCaseVariable(@NotNull Project project) {
        Variable result = null;
        try {
            URL schemaURL = new URL("oramds:/soa/shared/casemgmt/Case.xsd");
            QName rootElement = new QName("http://xmlns.oracle.com/bpm/case", "case");
            result = new Variable("case", 2, rootElement, 2, schemaURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

