/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import javax.swing.JFrame;
import oracle.bpm.casemgmt.model.Value;
import oracle.bpm.casemgmt.model.ValueType;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.components.CaseContext;
import oracle.bpm.casemgmt.ui.components.StaticTextPanel;
import oracle.bpm.casemgmt.ui.components.TextFieldButtonPanel;
import oracle.bpm.casemgmt.ui.components.XPathExpressionBuilderDialog;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import org.jetbrains.annotations.NotNull;

public class ValuePanel
extends Panel {
    private EditorsPanel editorsPanel;
    private ComboBox<ValueType> selector;

    public ValuePanel(UiContainer parent, @NotNull CaseContext caseContext, @NotNull Value value) {
        super(parent);
        this.init(caseContext, value);
    }

    public Value getValue() {
        return this.editorsPanel.getActiveEditor().getValue();
    }

    private void init(@NotNull CaseContext caseContext, @NotNull Value value) {
        this.setLayout(new MigLayout("hidemode 3, gapx 8, gapy 6, ins 0"));
        this.selector = UiFactory.createComboBox((UiContainer)this, ValueType.values());
        this.selector.setSelectedItem(value.getType());
        this.selector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    ValuePanel.this.editorsPanel.showEditor((ValueType)ValuePanel.this.selector.getSelectedItem());
                }
            }
        });
        this.editorsPanel = new EditorsPanel(this, caseContext, value);
        this.add(this.selector);
        this.add(this.editorsPanel);
    }

    private static class XPathValueEditor
    extends TextFieldButtonPanel
    implements ValueEditor {
        private CaseContext caseContext;
        private Value value;

        public XPathValueEditor(UiContainer parent, @NotNull CaseContext caseContext) {
            super(parent);
            this.caseContext = caseContext;
        }

        @Override
        public void setValue(Value value) {
            this.value = value;
            this.setComponentValue(value.getValue());
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public ValueType getType() {
            return ValueType.XPATH;
        }

        @Override
        protected Msg getMsg() {
            return CaseModelMsg.XPATH;
        }

        @Override
        protected void onButtonClick() {
            Case casemgmt = this.caseContext.getCase();
            Project project = this.caseContext.getProject();
            XPathExpressionBuilderDialog dialog = XPathExpressionBuilderDialog.create((JFrame)Ide.getMainWindow(), project, casemgmt, this.getComponentValue());
            if (dialog.display() == 0) {
                String expressionText = dialog.getExpressionText();
                this.getValue().setValue(expressionText);
                this.setComponentValue(expressionText);
                dialog.updateCasePrefixes(casemgmt);
            }
        }

        @Override
        protected void change(String value) {
            this.getValue().setValue(value);
        }
    }

    private static class StaticValueEditor
    extends StaticTextPanel
    implements ValueEditor {
        private Value value;

        public StaticValueEditor(UiContainer parent) {
            super(parent);
        }

        @Override
        public void setValue(Value value) {
            this.value = value;
            this.setComponentValue(value.getValue());
        }

        @Override
        public Value getValue() {
            return this.value;
        }

        @Override
        public ValueType getType() {
            return ValueType.STATIC;
        }

        @Override
        protected void change(String value) {
            this.getValue().setValue(value);
        }
    }

    private static class EditorsPanel
    extends Panel {
        private ValueEditor activeEditor;
        private Value value;

        public EditorsPanel(UiContainer parent, @NotNull CaseContext caseContext, Value value) {
            super(parent);
            this.value = value;
            this.init(caseContext);
        }

        @Override
        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void showEditor(ValueType type) {
            if (this.activeEditor == null || !this.activeEditor.getType().equals((Object)type)) {
                this.activeEditor = (ValueEditor)((Object)this.getLayout().getComponent(type.name()));
                this.activeEditor.setValue(type.isStatic() ? this.value.toStatic() : this.value.toXPath());
                this.getLayout().show(this, type.name());
            }
        }

        public ValueEditor getActiveEditor() {
            return this.activeEditor;
        }

        private void init(@NotNull CaseContext caseContext) {
            this.setLayout(new CardLayout());
            this.add(new StaticValueEditor(this), ValueType.STATIC.name());
            this.add(new XPathValueEditor((UiContainer)this, caseContext), ValueType.XPATH.name());
            this.showEditor(this.value.getType());
        }
    }

    private static interface ValueEditor {
        public void setValue(Value var1);

        public Value getValue();

        public ValueType getType();
    }
}

