/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.PropertyBundles;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.components.CaseContext;
import oracle.bpm.casemgmt.ui.components.TranslationDialog;
import oracle.bpm.casemgmt.ui.components.XPathExpressionBuilderDialog;
import oracle.bpm.collections.Tuple;
import oracle.bpm.lang.Any;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.jdeveloper.JDevProject;
import oracle.tip.tools.ide.common.services.translation.IKeyRepository;
import oracle.tip.tools.ide.common.services.translation.IXPathBrowser;
import oracle.tip.tools.ide.common.services.translation.RepositoryManager;
import oracle.tip.tools.ide.common.services.translation.TranslationBrowser;
import oracle.tip.tools.ide.common.services.translation.TranslationContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslationService {
    private CaseContext caseContext;
    private TranslationContext translationContext;
    private static final String RESOURCES = "resources";

    private TranslationService(@NotNull CaseContext caseContext) {
        this.caseContext = caseContext;
        this.init();
    }

    public static TranslationService create(@NotNull CaseContext caseContext) {
        return new TranslationService(caseContext);
    }

    public static URL getResourcesUrl(Project project) {
        URL projectUrl = URLFileSystem.getParent((URL)project.getURL());
        URL resourcesUrl = URLFactory.newDirURL((URL)projectUrl, (String)RESOURCES);
        if (!URLFileSystem.exists((URL)resourcesUrl)) {
            URLFileSystem.mkdir((URL)resourcesUrl);
        }
        return resourcesUrl;
    }

    public Tuple<String, String> showDialog(@NotNull UiWindow parent, @NotNull Msg title, @Nullable String currentKey) {
        PropertyBundle bundle = this.getDefaultPropertyBundle();
        return TranslationDialog.show(parent, title, currentKey, bundle);
    }

    public String showDialogWithParams(@NotNull UiComponent component, @Nullable String currentKey, Collection<String> params) {
        TranslationContext context;
        this.translationContext.setCurrentKey(currentKey);
        boolean supportParams = params != null;
        this.translationContext.setUseStaticValues(!supportParams);
        if (supportParams) {
            this.translationContext.setValues(params);
            this.translationContext.setXPathBrowser(new IXPathBrowser(){

                public String getXPath(String pCurrentValue, Component pComponent) {
                    String result = null;
                    Case casemgmt = TranslationService.this.caseContext.getCase();
                    Project project = TranslationService.this.caseContext.getProject();
                    XPathExpressionBuilderDialog dialog = XPathExpressionBuilderDialog.create((JFrame)Ide.getMainWindow(), project, casemgmt, pCurrentValue);
                    if (dialog.display() == 0) {
                        result = dialog.getExpressionText();
                        dialog.updateCasePrefixes(casemgmt);
                    }
                    return result;
                }
            });
        }
        return (context = new TranslationBrowser().browse((Component)component.asSwing(), this.translationContext)) != null ? context.getCurrentKey() : null;
    }

    public Collection<String> getParams() {
        ArrayList<String> result = new ArrayList<String>();
        Collection values = this.translationContext.getValues();
        for (String value : values) {
            result.add(value != null ? value : "");
        }
        return result;
    }

    public CaseContext getCaseContext() {
        return this.caseContext;
    }

    public String getValue(String key) {
        Case casemgmt = this.getCase();
        PropertyBundle bundle = casemgmt.getPropertyBundles().getDefault();
        return (String)bundle.get((Object)key);
    }

    public Case getCase() {
        return this.getCaseContext().getCase();
    }

    public PropertyBundle getDefaultPropertyBundle() {
        Case casemgmt = this.caseContext.getCase();
        PropertyBundles propertyBundles = casemgmt.getPropertyBundles();
        return propertyBundles.getDefault();
    }

    private void init() {
        final Case casemgmt = this.caseContext.getCase();
        final PropertyBundle propertyBundle = this.getDefaultPropertyBundle();
        Project project = this.caseContext.getProject();
        final URL resourcesUrl = TranslationService.getResourcesUrl(project);
        this.translationContext = new TranslationContext();
        RepositoryManager repositoryManager = new RepositoryManager((IDEProject)new JDevProject(project));
        IKeyRepository keyRepository = new IKeyRepository(){

            public void addNewKey(String key, String text) {
                propertyBundle.put((Object)key, (Object)text);
            }

            public Collection<String> getKeys() {
                return propertyBundle.keySet();
            }

            public String getTemplate(String key) {
                return (String)propertyBundle.get((Object)key);
            }

            public void keyUpdated(String key, String text, String oldKey, String oldText) {
                boolean isChangeKey = false;
                if (!Any.equals(key, oldKey)) {
                    propertyBundle.remove((Object)oldKey);
                    isChangeKey = true;
                }
                propertyBundle.put((Object)key, (Object)text);
                if (isChangeKey) {
                    TranslationService.this.translationContext.setCurrentKey(key);
                }
            }

            public String getResourceBundleName() {
                return casemgmt.getResourceBundle();
            }

            public void setResourceBundleName(String name) {
            }

            public URL getResourceLocation() {
                return resourcesUrl;
            }

            public void setResourceLocation(URL url) {
            }

            public void loadKeys() {
            }
        };
        this.translationContext.setRepository(keyRepository);
        repositoryManager.setRepository(keyRepository);
    }
}

