/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;

class TranslationPanel
extends Panel {
    private IdentifierTextField nameTextField;
    private PropertyBundle root;
    private TextField translationTextField;

    public TranslationPanel(UiContainer parent, PropertyBundle root, String currentKey) {
        super(parent);
        this.root = root;
        this.init(currentKey);
    }

    public Tuple<String, String> getKeyValue() {
        String name = this.nameTextField.getText();
        return Tuple.create(name.trim(), this.translationTextField.getText().trim());
    }

    private void init(String currentKey) {
        this.nameTextField = new IdentifierTextField((UiContainer)this, currentKey, 30, true);
        this.translationTextField = new TextField((UiContainer)this, this.getDisplayName(currentKey), 30);
        this.nameTextField.addDocumentListener(new DocumentListener.Default(){

            @Override
            public void anyUpdate(DocumentEvent e) {
                TranslationPanel.this.translationTextField.setText(TranslationPanel.this.getDisplayName(TranslationPanel.this.nameTextField.getText()));
            }
        });
        this.setLayout(new MigLayout("fillx, gapx 8, gapy 6, ins 0"));
        this.add(Label.create((UiContainer)this, CoreMsg.NAME));
        this.add(this.nameTextField, "growx, pushx, wrap");
        this.add(Label.create((UiContainer)this, CaseUiMsg.DISPLAY_NAME));
        this.add(this.translationTextField);
    }

    private String getDisplayName(String key) {
        String value = key != null ? (String)this.root.get((Object)key) : null;
        return value == null ? key : value;
    }
}

