/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.ui.components.TranslationPanel;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TranslationDialog
extends JEWTDialog {
    private TranslationPanel translationPanel;

    private TranslationDialog(Frame parent, Msg title, @Nullable String currentKey, @NotNull PropertyBundle sourceBundle) {
        super(parent, title.getString(), 7);
        this.init(currentKey, sourceBundle);
    }

    private TranslationDialog(Dialog parent, Msg title, @Nullable String currentKey, @NotNull PropertyBundle sourceBundle) {
        super(parent, title.getString(), 7);
        this.init(currentKey, sourceBundle);
    }

    @Nullable
    public static Tuple<String, String> show(UiWindow parent, @NotNull Msg title, @Nullable String currentKey, @NotNull PropertyBundle bundle) {
        Object parentNative = parent.getNative();
        TranslationDialog dialog = parentNative instanceof Frame ? new TranslationDialog((Frame)parentNative, title, currentKey, bundle) : (parentNative instanceof Dialog ? new TranslationDialog((Dialog)parentNative, title, currentKey, bundle) : new TranslationDialog((Frame)Ide.getMainWindow(), title, currentKey, bundle));
        boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
        Tuple<String, String> result = null;
        if (ok) {
            result = dialog.getKeyValue();
            bundle.put((Object)result.getFirst(), (Object)result.getSecond());
        }
        return result;
    }

    public Tuple<String, String> getKeyValue() {
        return this.translationPanel.getKeyValue();
    }

    private void init(@Nullable String currentKey, @NotNull PropertyBundle sourceBundle) {
        this.translationPanel = new TranslationPanel(UiContainer.NULL, sourceBundle, currentKey);
        VetoableChangeListener OkListener = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    Tuple<String, String> keyValue = TranslationDialog.this.translationPanel.getKeyValue();
                    if (keyValue.getFirst().isEmpty()) {
                        MessageDialog.showError(CaseUiMsg.INVALID_NAME, CaseUiMsg.INVALID_NAME_DESCRIPTION);
                        throw new PropertyVetoException("", evt);
                    }
                    if (keyValue.getSecond().isEmpty()) {
                        MessageDialog.showError(CaseUiMsg.INVALID_DISPLAY_NAME, CaseUiMsg.INVALID_DISPLAY_NAME_DESCRIPTION);
                        throw new PropertyVetoException("", evt);
                    }
                }
            }
        };
        this.addVetoableChangeListener(OkListener);
        this.setContent(this.translationPanel.asSwing());
    }
}

