/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.util.Collection;
import oracle.bpm.casemgmt.model.Translatable;
import oracle.bpm.casemgmt.model.TranslatableType;
import oracle.bpm.casemgmt.model.msg.CaseModelMsg;
import oracle.bpm.casemgmt.ui.components.StaticTextPanel;
import oracle.bpm.casemgmt.ui.components.TextFieldButtonPanel;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class TranslatablePanel
extends Panel {
    private EditorsPanel editorsPanel;
    private ComboBox<TranslatableType> selector;

    public TranslatablePanel(UiContainer parent, @NotNull TranslationService translationService, @NotNull Translatable value) {
        super(parent);
        this.init(translationService, value);
    }

    public Translatable getValue() {
        return this.editorsPanel.getActiveEditor().getTranslatable();
    }

    private void init(@NotNull TranslationService translationService, @NotNull Translatable value) {
        this.setLayout(new MigLayout("hidemode 3, gapx 8, gapy 6, ins 0"));
        this.selector = UiFactory.createComboBox((UiContainer)this, TranslatableType.values());
        this.selector.setSelectedItem(value.getTranslatableType());
        this.selector.setBackground(Color.WHITE);
        this.selector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    TranslatablePanel.this.editorsPanel.showEditor((TranslatableType)TranslatablePanel.this.selector.getSelectedItem());
                }
            }
        });
        this.editorsPanel = new EditorsPanel(this, translationService, value);
        this.add(this.selector);
        this.add(this.editorsPanel);
    }

    private static class StaticTranslatableEditor
    extends StaticTextPanel
    implements TranslatableEditor {
        private Translatable value;

        public StaticTranslatableEditor(UiContainer parent) {
            super(parent);
        }

        @Override
        public void setTranslatable(Translatable value) {
            this.value = value;
            this.setComponentValue(value.getValue());
        }

        @Override
        public Translatable getTranslatable() {
            return this.value;
        }

        @Override
        public TranslatableType getType() {
            return TranslatableType.STATIC;
        }

        @Override
        protected void change(String value) {
            this.getTranslatable().setValue(value);
        }
    }

    private static class ResourceTranslatableEditor
    extends TextFieldButtonPanel
    implements TranslatableEditor {
        private Translatable translatable;
        private TranslationService translationService;

        public ResourceTranslatableEditor(UiContainer parent, @NotNull TranslationService translationService) {
            super(parent);
            ((TextField)this.getComponent()).setEditable(false);
            this.translationService = translationService;
        }

        @Override
        public void setTranslatable(Translatable value) {
            this.translatable = value;
            String key = value.getValue();
            this.setComponentValue(this.translationService.getValue(key));
        }

        @Override
        public Translatable getTranslatable() {
            return this.translatable;
        }

        @Override
        public TranslatableType getType() {
            return TranslatableType.RESOURCE;
        }

        @Override
        protected Msg getMsg() {
            return CaseModelMsg.TRANSLATION;
        }

        @Override
        protected void onButtonClick() {
            Translatable.Resource resource = this.translatable.toResource();
            String key = this.translationService.showDialogWithParams(this, resource.getValue(), (Collection<String>)resource.getParams());
            if (key != null) {
                resource.setValue(key);
                this.setComponentValue(this.translationService.getValue(key));
                Translatable.Params params = resource.getParams();
                params.clear();
                params.addAll(this.translationService.getParams());
            }
        }
    }

    private static class EditorsPanel
    extends Panel {
        private TranslatableEditor activeEditor;
        private Translatable translatable;

        public EditorsPanel(UiContainer parent, @NotNull TranslationService translationService, Translatable value) {
            super(parent);
            this.translatable = value;
            this.init(translationService);
        }

        @Override
        public CardLayout getLayout() {
            return (CardLayout)super.getLayout();
        }

        public void showEditor(TranslatableType type) {
            if (this.activeEditor == null || !this.activeEditor.getType().equals((Object)type)) {
                this.activeEditor = (TranslatableEditor)((Object)this.getLayout().getComponent(type.name()));
                this.activeEditor.setTranslatable((Translatable)(type.isStatic() ? this.translatable.toStatic() : this.translatable.toResource()));
                this.getLayout().show(this, type.name());
            }
        }

        public TranslatableEditor getActiveEditor() {
            return this.activeEditor;
        }

        private void init(@NotNull TranslationService translationService) {
            this.setLayout(new CardLayout());
            this.add(new StaticTranslatableEditor(this), TranslatableType.STATIC.name());
            this.add(new ResourceTranslatableEditor((UiContainer)this, translationService), TranslatableType.RESOURCE.name());
            this.showEditor(this.translatable.getTranslatableType());
        }
    }

    private static interface TranslatableEditor {
        public void setTranslatable(Translatable var1);

        public Translatable getTranslatable();

        public TranslatableType getType();
    }
}

