/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bpm.casemgmt.ui.components.HeaderPanelBuilder;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.peer.swing.SwingTable;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;
import org.jetbrains.annotations.Nullable;

public abstract class TableHeaderPanelBuilder<E>
extends HeaderPanelBuilder {
    private GenericTable table;
    private ProviderTableModel<E> tableModel;

    public TableHeaderPanelBuilder(Msg title) {
        this(title, null);
    }

    public TableHeaderPanelBuilder(Msg title, @Nullable Msg description) {
        super(title, description);
    }

    public abstract ProviderTableModel<E> createTableModel();

    protected static void setColumnSize(TableColumn column, int value) {
        column.setMaxWidth(value);
        column.setWidth(value);
        column.setPreferredWidth(value);
    }

    @Override
    protected void addAction() {
    }

    @Override
    protected void editAction() {
        int row = this.getTable().getSelectedRow();
        this.editAction(this.tableModel.getRow(row), row);
    }

    protected void editAction(E toEdit, int row) {
    }

    @Override
    protected void removeAction() {
        int[] selection;
        this.stopCellEditor();
        ArrayList<E> toRemove = new ArrayList<E>();
        for (int row : selection = this.getTable().getSelectedRows()) {
            E object = this.tableModel.getRow(row);
            if (object == null) continue;
            toRemove.add(object);
        }
        this.removeAction(Collections.unmodifiableList(toRemove));
        if (selection.length >= 1) {
            int previousSelection = selection[0];
            int count = this.getTable().getRowCount();
            if (previousSelection >= count) {
                previousSelection = count - 1;
            }
            if (previousSelection >= 0) {
                this.getTable().setRowSelectionInterval(previousSelection, previousSelection);
            }
        }
    }

    protected void removeAction(List<E> toRemove) {
    }

    protected void selectionChanged(int[] selectedRows) {
        if (this.isShowRemove()) {
            this.enableAction(4, selectedRows.length > 0);
        }
        if (this.isShowEdit()) {
            this.enableAction(2, selectedRows.length == 1);
        }
    }

    protected void addToModel(E toAdd) {
        this.getTableModel().addRow(toAdd);
        int index = this.getTableModel().getRowIndex(toAdd);
        this.getTable().getSelectionModel().setSelectionInterval(index, index);
    }

    protected void tableModelChanged() {
        ListSelectionModel selectionModel = this.getTable().getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        this.getTableModel().fireTableDataChanged();
        selectionModel.setSelectionInterval(min, max);
    }

    protected GenericTable getTable() {
        return this.table;
    }

    protected ProviderTableModel<E> getTableModel() {
        return this.tableModel;
    }

    protected void editingStarted() {
        this.selectionChanged(new int[0]);
    }

    protected void editingStopped() {
        this.selectionChanged(this.table.getSelectedRows());
    }

    protected void editingCanceled() {
        this.editingStopped();
    }

    @Override
    protected UiComponent buildEditor(UiContainer parent) {
        this.table = new GenericTable(){

            public boolean editCellAt(int row, int column, EventObject e) {
                boolean isEditing = super.editCellAt(row, column, e);
                if (isEditing) {
                    TableHeaderPanelBuilder.this.editingStarted();
                }
                return isEditing;
            }

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
                TableHeaderPanelBuilder.this.editingStopped();
            }

            public void removeEditor() {
                super.removeEditor();
                TableHeaderPanelBuilder.this.editingCanceled();
            }
        };
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)true);
        this.table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new BooleanRenderer());
        this.tableModel = this.createTableModel();
        this.table.setModel((TableModel)new SwingTable.SwingTableModel(this.tableModel));
        this.customizeTable(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableHeaderPanelBuilder.this.selectionChanged(TableHeaderPanelBuilder.this.table.getSelectedRows());
            }
        });
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createEtchedBorder());
        result.setLayout(new BorderLayout());
        result.add((Component)this.table.getTableHeader(), "North");
        result.add((Component)this.table, "Center");
        return UiComponent.get(result);
    }

    protected void customizeTable(GenericTable table) {
    }

    protected UiWindow getOwnerWindow() {
        return this.getEditor().getOwnerWindow();
    }

    private void stopCellEditor() {
        TableCellEditor editor = this.getTable().getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            this.setBorder(noFocusBorder);
            return this;
        }
    }
}

