/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.awt.Component;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.dialog.DesignerDialogFactory;
import oracle.bpm.designer.dialog.organization.RoleDialog;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;

public class RoleChooserPanel
extends Panel {
    private ComboBox<Role> comboBox;

    public RoleChooserPanel(UiContainer parent, Organization organization, Role defaultValue) {
        super(parent);
        this.init(organization, defaultValue);
    }

    public static Role showDialog(Organization organization, Role defaultValue) {
        RoleChooserPanel panel = new RoleChooserPanel(UiContainer.NULL, organization, defaultValue);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel.asSwing(), null, (String)"Select Role");
        HelpSystem.getHelpSystem().registerTopic(panel.asSwing(), "f1_bpm_casemgselroled_html");
        dlg.setDefaultButton(1);
        dlg.setOKButtonEnabled(true);
        boolean ok = WizardLauncher.runDialog((JDialog)dlg);
        return ok ? panel.getRole() : null;
    }

    public Role getRole() {
        return this.comboBox.getSelectedItem();
    }

    private void init(final Organization organization, Role defaultValue) {
        this.setLayout(new MigLayout("fill, gapx 8, gapy 6, ins 0"));
        Sequence roles = organization.getRoles();
        this.comboBox = UiFactory.createComboBox((UiContainer)this, CollectionUtils.toList(roles));
        if (defaultValue != null) {
            this.comboBox.setSelectedItem(defaultValue);
        }
        this.comboBox.setPrototypeDisplayValue("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
        this.comboBox.setLabelProvider((LabelProvider<Role>)new LabelProvider.Default<Role>(){

            @Override
            public String getText(Role element) {
                return element.getId();
            }
        });
        Button button = Button.createIconic(this, UIMsg.ADD);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoleDialog dialog = DesignerDialogFactory.createRoleDialog((UiWindow)RoleChooserPanel.this.getOwnerWindow(), (Organization)organization);
                dialog.setVisible(true);
                if (dialog.userAccepted()) {
                    Role newRole = (Role)dialog.getProjectObjectAdded();
                    RoleChooserPanel.this.comboBox.addItem(newRole);
                    RoleChooserPanel.this.comboBox.setSelectedItem(newRole);
                }
            }
        });
        this.add(this.comboBox);
        this.add(button);
    }
}

