/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import org.jetbrains.annotations.Nullable;

public abstract class HeaderPanelBuilder {
    private Msg description;
    private Action editAction;
    private UiComponent editor;
    private Header header;
    private boolean isExpanded;
    private Action removeAction;
    private Msg title;
    public static final int SHOW_NOTHING = 0;
    public static final int SHOW_ADD = 1;
    public static final int SHOW_EDIT = 2;
    public static final int SHOW_REMOVE = 4;
    public static final int SHOW_ADD_REMOVE = 5;
    public static final int SHOW_ADD_EDIT_REMOVE = 7;
    public static boolean COLLAPSED = false;
    private static final Action[] NO_ACTIONS = new Action[0];

    protected HeaderPanelBuilder(Msg title) {
        this(title, null);
    }

    protected HeaderPanelBuilder(Msg title, @Nullable Msg description) {
        this(title, description, true);
    }

    protected HeaderPanelBuilder(Msg title, @Nullable Msg description, boolean isExpanded) {
        this.title = title;
        this.description = description;
        this.isExpanded = isExpanded;
    }

    public final UiComponent build(UiContainer parent) {
        if (this.editor == null) {
            Panel container = new Panel(parent);
            HeaderPanel headerPanel = new HeaderPanel();
            this.header = headerPanel.getHeader();
            this.header.setText(this.title.getString());
            this.header.setLevel(this.getHeaderLevel());
            this.header.setExpanded(this.isExpanded);
            this.buildToolBar(this.header);
            if (this.description != null) {
                headerPanel.setStaticHelpText(this.description.getString());
            }
            headerPanel.setHostedComponent(this.buildEditor(container).asSwing());
            this.editor = UiComponent.get(headerPanel);
        }
        return this.editor;
    }

    public UiComponent getEditor() {
        return this.editor;
    }

    protected abstract UiComponent buildEditor(UiContainer var1);

    protected Header.Level getHeaderLevel() {
        return Header.Level.SUB;
    }

    protected void setTitle(Msg msg) {
        this.title = msg;
        if (this.header != null) {
            this.header.setText(msg.getString());
        }
    }

    protected void setExpanded(boolean isExpanded) {
        if (this.header != null) {
            this.header.setExpanded(isExpanded);
        }
        this.isExpanded = isExpanded;
    }

    protected int actions() {
        return 0;
    }

    protected void addAction() {
    }

    protected void editAction() {
    }

    protected void removeAction() {
    }

    protected Action[] beforeCustomActions() {
        return NO_ACTIONS;
    }

    protected Action[] customActions() {
        return NO_ACTIONS;
    }

    protected Action[] addActions() {
        AbstractAction action = new AbstractAction("", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeaderPanelBuilder.this.addAction();
            }
        };
        return new Action[]{action};
    }

    protected void enableAction(int action, boolean value) {
        if (this.isShow(action)) {
            switch (action) {
                case 2: {
                    this.editAction.setEnabled(value);
                    break;
                }
                case 4: {
                    this.removeAction.setEnabled(value);
                }
            }
        }
    }

    protected boolean isShowAdd() {
        return this.isShow(1);
    }

    protected boolean isShowEdit() {
        return this.isShow(2);
    }

    protected boolean isShowRemove() {
        return this.isShow(4);
    }

    protected boolean isShow(int action) {
        return (this.actions() & action) != 0;
    }

    private void buildToolBar(Header header) {
        this.appendActions(header, this.beforeCustomActions());
        if (this.isShowAdd()) {
            Action[] actions = this.addActions();
            if (actions.length == 1) {
                header.addActionControl(actions[0]);
            } else if (actions.length > 1) {
                ButtonMenu bm = new ButtonMenu("", OracleIcons.getIcon((String)"add.png"));
                bm.setActions(actions);
                header.addActionControl((Component)bm);
            }
        }
        if (this.isShowEdit()) {
            this.editAction = new AbstractAction("", OracleIcons.getIcon((String)"edit.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeaderPanelBuilder.this.editAction();
                }
            };
            this.enableAction(2, false);
            header.addActionControl(this.editAction);
        }
        if (this.isShowRemove()) {
            this.removeAction = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeaderPanelBuilder.this.removeAction();
                }
            };
            this.enableAction(4, false);
            header.addActionControl(this.removeAction);
        }
        this.appendActions(header, this.customActions());
    }

    private void appendActions(Header header, Action[] customActions) {
        for (Action action : customActions) {
            header.addActionControl(action);
        }
    }
}

