/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.components;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.Nullable;

public class FormBuilder {
    public static final String EDITOR_LAYOUT = "fillx, width max(100,50%), gapx 8, gapy 6, ins 8";
    public static final String LAYOUT_WITHOUT_MARGING = "fillx, gapx 8, gapy 6, ins 0";

    private FormBuilder() {
    }

    public static UiComponent createHeader(UiContainer parent, Image image, Msg msg, Msg description) {
        Panel result = new Panel(parent);
        result.setLayout(new BorderLayout(8, 6));
        Label imageLabel = Label.create((UiContainer)result, image);
        Panel textPanel = new Panel(parent);
        textPanel.setLayout(new BorderLayout());
        Label textLabel = Label.createWithNoColon((UiContainer)textPanel, msg);
        Font bold = textLabel.getFont().bold();
        textLabel.setFont(bold);
        Label descLabel = Label.createWithNoColon((UiContainer)textPanel, description);
        descLabel.setForeground(Color.GRAY);
        textPanel.add(textLabel, "North");
        textPanel.add(descLabel, "Center");
        result.add(imageLabel, "West");
        result.add(textPanel, "Center");
        result.add(new Separator(result), "South");
        return result;
    }

    public static MigLayout createLayoutWithMargin() {
        return new MigLayout(EDITOR_LAYOUT);
    }

    public static MigLayout createLayoutWithoutMargin() {
        return new MigLayout(LAYOUT_WITHOUT_MARGING);
    }

    public static void add(UiContainer parent, Msg msg, UiComponent component) {
        parent.add(Label.create(parent, msg));
        FormBuilder.add(parent, component, "pushx, wrap");
    }

    public static void add(UiContainer parent, UiComponent component) {
        FormBuilder.add(parent, component, "spanx 2, wrap");
    }

    public static void addIndent(UiContainer parent, UiComponent component) {
        FormBuilder.add(parent, component, "gapx 10, spanx 2, wrap");
    }

    public static void addExpandX(UiContainer parent, UiComponent component) {
        FormBuilder.add(parent, component, "growx, spanx 2, wrap");
    }

    private static void add(UiContainer parent, UiComponent component, @Nullable String constraint) {
        parent.add(component, constraint);
    }
}

