/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import oracle.ide.model.Project;
import oracle.javatools.xml.bind.ElementList;
import oracle.jdeveloper.xml.wl.LibraryRef;
import oracle.jdeveloper.xml.wl.war.SessionDescriptor;
import oracle.jdeveloper.xml.wl.war.WeblogicWebApp;
import oracle.jdeveloper.xml.wl.war.WeblogicWebAppNode;

public class WeblogicXmlHelper {
    private Project project;
    private WeblogicWebApp weblogicWebApp;
    private WeblogicWebAppNode weblogicWebAppNode;

    public WeblogicXmlHelper(Project project) throws Exception {
        this.project = project;
        this.weblogicWebAppNode = WeblogicWebAppNode.findOrCreateIn((Project)this.project, null, (boolean)true, (boolean)false);
        this.weblogicWebApp = this.weblogicWebAppNode.getWeblogicWebApp();
    }

    public boolean update() throws Exception {
        if (this.weblogicWebAppNode == null) {
            return false;
        }
        boolean sessionDescUpdated = this.addSessionDescriptor();
        boolean libRefsUpdated = this.addLibraryRefs();
        if (sessionDescUpdated || libRefsUpdated) {
            this.weblogicWebAppNode.commit();
            this.weblogicWebAppNode.save();
            return true;
        }
        return false;
    }

    private boolean addSessionDescriptor() {
        if (this.weblogicWebApp == null) {
            return false;
        }
        SessionDescriptor sessionDesc = this.weblogicWebApp.getSessionDescriptor();
        if (sessionDesc == null) {
            sessionDesc = this.weblogicWebApp.createSessionDescriptor();
        }
        sessionDesc.setPersistentStoreType("replicated_if_clustered");
        this.weblogicWebApp.setSessionDescriptor(sessionDesc);
        return true;
    }

    private boolean addLibraryRefs() {
        if (this.weblogicWebApp == null) {
            return false;
        }
        boolean added = false;
        if (!this.libraryRefExists("oracle.soa.worklist.webapp")) {
            LibraryRef ref1 = this.weblogicWebApp.createLibraryRef();
            ref1.setLibraryName("oracle.soa.worklist.webapp");
            this.weblogicWebApp.getLibraryRefs().add((Object)ref1);
            added = true;
        }
        return added;
    }

    private boolean libraryRefExists(String libName) {
        if (this.weblogicWebApp == null) {
            return false;
        }
        if (libName == null) {
            return false;
        }
        ElementList libRefs = this.weblogicWebApp.getLibraryRefs();
        if (libRefs.isEmpty()) {
            return false;
        }
        for (LibraryRef libRef : libRefs) {
            if (!libName.equals(libRef.getLibraryName())) continue;
            return true;
        }
        return false;
    }
}

