/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.util.ArrayList;
import oracle.ide.model.Workspace;
import oracle.javatools.xml.bind.ElementList;
import oracle.jdeveloper.xml.wl.LibraryRef;
import oracle.jdeveloper.xml.wl.ear.Listener;
import oracle.jdeveloper.xml.wl.ear.WeblogicApplication;
import oracle.jdeveloper.xml.wl.ear.WeblogicApplicationNode;

public class WeblogicApplicationXmlHelper {
    private WeblogicApplication weblogicApp;
    private WeblogicApplicationNode weblogicAppNode;
    private Workspace ws;
    private static final String ADF_ORACLE_DOMAIN = "adf.oracle.domain";
    private static final String ORACLE_SOA_BPEL = "oracle.soa.bpel";
    private static final String ORACLE_SOA_WORKFLOW_WC = "oracle.soa.workflow.wc";
    private static final String ORACLE_BPM_RUNTIME = "oracle.bpm.runtime";
    private static final String TF_LIFE_CYCLE_LISTENER = "oracle.bpm.casemgmt.client.forms.servlet.TFLifecycleListener";

    public WeblogicApplicationXmlHelper(Workspace ws) throws Exception {
        this.ws = ws;
        this.weblogicAppNode = WeblogicApplicationNode.findOrCreateIn((Workspace)ws, null, (boolean)true, (boolean)false);
        this.weblogicApp = this.weblogicAppNode.getWeblogicApplication();
    }

    public boolean update() throws Exception {
        if (this.weblogicApp == null) {
            return false;
        }
        boolean libRefsUpdated = this.addLibraryRefs();
        boolean listenersUpdated = this.addListeners();
        if (libRefsUpdated || listenersUpdated) {
            this.weblogicAppNode.commit();
            this.weblogicAppNode.save();
            return true;
        }
        return false;
    }

    private boolean addLibraryRefs() {
        if (this.weblogicApp == null) {
            return false;
        }
        boolean addedLibRef = false;
        if (!this.libraryRefExists(ADF_ORACLE_DOMAIN)) {
            LibraryRef adfOrclDomainLibRef = this.weblogicApp.createLibraryRef();
            adfOrclDomainLibRef.setLibraryName(ADF_ORACLE_DOMAIN);
            this.weblogicApp.getLibraryRefs().add((Object)adfOrclDomainLibRef);
            addedLibRef = true;
        }
        if (!this.libraryRefExists(ORACLE_SOA_BPEL)) {
            LibraryRef orclSoaBpelLibRef = this.weblogicApp.createLibraryRef();
            orclSoaBpelLibRef.setLibraryName(ORACLE_SOA_BPEL);
            this.weblogicApp.getLibraryRefs().add((Object)orclSoaBpelLibRef);
            addedLibRef = true;
        }
        if (!this.libraryRefExists(ORACLE_SOA_WORKFLOW_WC)) {
            LibraryRef orclSoaWfWc = this.weblogicApp.createLibraryRef();
            orclSoaWfWc.setLibraryName(ORACLE_SOA_WORKFLOW_WC);
            this.weblogicApp.getLibraryRefs().add((Object)orclSoaWfWc);
            addedLibRef = true;
        }
        if (!this.libraryRefExists(ORACLE_BPM_RUNTIME)) {
            LibraryRef orclBpmRuntime = this.weblogicApp.createLibraryRef();
            orclBpmRuntime.setLibraryName(ORACLE_BPM_RUNTIME);
            this.weblogicApp.getLibraryRefs().add((Object)orclBpmRuntime);
            addedLibRef = true;
        }
        return addedLibRef;
    }

    private boolean addListeners() {
        if (this.weblogicApp == null) {
            return false;
        }
        boolean addedListener = false;
        ArrayList<String> listenerList = new ArrayList<String>();
        listenerList.add(TF_LIFE_CYCLE_LISTENER);
        ElementList listenerElemList = this.weblogicApp.getListeners();
        for (String listenerClass : listenerList) {
            if (this.listenerExists(listenerElemList, listenerClass)) continue;
            Listener listener = this.weblogicApp.createListener();
            listener.setListenerClass(listenerClass);
            listenerElemList.add((Object)listener);
            addedListener = true;
        }
        return addedListener;
    }

    private boolean listenerExists(ElementList listenerElemList, String listenerClass) {
        if (listenerElemList == null || listenerClass == null) {
            return false;
        }
        for (Listener listener : listenerElemList) {
            if (!listenerClass.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    private boolean libraryRefExists(String libraryName) {
        if (this.weblogicApp == null) {
            return false;
        }
        ElementList libRefElemList = this.weblogicApp.getLibraryRefs();
        for (LibraryRef libRef : libRefElemList) {
            if (!libRef.getLibraryName().equals(libraryName)) continue;
            return true;
        }
        return false;
    }
}

