/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import oracle.ide.model.Project;
import oracle.javatools.xml.bind.ElementList;
import oracle.jdeveloper.xml.j2ee.war.Filter;
import oracle.jdeveloper.xml.j2ee.war.FilterMapping;
import oracle.jdeveloper.xml.j2ee.war.Servlet;
import oracle.jdeveloper.xml.j2ee.war.WebApp;
import oracle.jdeveloper.xml.j2ee.war.WebAppNode;

public class WebXmlHelper {
    private Project project;
    private WebApp webApp;
    private WebAppNode webAppNode;

    public WebXmlHelper(Project project) throws Exception {
        this.project = project;
        this.webAppNode = WebAppNode.findOrCreateIn((Project)this.project, null, (boolean)true, (boolean)false);
        this.webApp = this.webAppNode.getWebApp();
    }

    public boolean update() throws Exception {
        FilterMapping urlDisableMapping;
        ElementList urlDisableFilterMapping;
        if (this.webApp == null || this.webAppNode == null) {
            return false;
        }
        this.webApp.setDescription("Case form web.xml");
        this.webApp.addContextParam("oracle.adf.view.rich.security.FRAME_BUSTING", "never");
        this.webApp.addContextParam("org.apache.myfaces.trinidad.COMPRESS_VIEW_STATE", "true");
        this.webApp.addContextParam("org.apache.myfaces.trinidad.CLIENT_STATE_MAX_TOKENS", "3");
        this.webApp.addContextParam("org.apache.myfaces.trinidad.DISABLE_CONTENT_COMPRESSION", "false");
        Filter urlDisableFilter = this.webApp.findFilter("DisableUrlSessionFilter");
        if (urlDisableFilter == null) {
            this.webApp.addFilter("DisableUrlSessionFilter", "oracle.bpel.services.workflow.client.worklist.util.DisableUrlSessionFilter");
        }
        if ((urlDisableFilterMapping = this.webApp.findFilterMappings("DisableUrlSessionFilter")) == null || urlDisableFilterMapping.size() == 0) {
            urlDisableMapping = this.webApp.addFilterMappingUrlPattern("DisableUrlSessionFilter", "/faces/*");
            urlDisableMapping.getDispatchers().add((Object)"FORWARD");
            urlDisableMapping.getDispatchers().add((Object)"REQUEST");
        } else {
            urlDisableMapping = (FilterMapping)urlDisableFilterMapping.get(0);
            if (urlDisableMapping.getDispatchers().size() == 0) {
                urlDisableMapping.getDispatchers().add((Object)"FORWARD");
                urlDisableMapping.getDispatchers().add((Object)"REQUEST");
            }
        }
        Filter filter = this.webApp.findFilter("adfBindings");
        if (filter == null) {
            this.webApp.addFilter("adfBindings", "oracle.adf.model.servlet.ADFBindingFilter");
        }
        ElementList filterMapping = this.webApp.findFilterMappings("adfBindings");
        boolean addBinding = false;
        if (filterMapping == null || filterMapping.size() == 0) {
            addBinding = true;
        } else {
            for (int i = 0; i < filterMapping.size(); ++i) {
                FilterMapping fMap = (FilterMapping)filterMapping.get(i);
                String servletName = fMap.getServletName();
                addBinding = true;
                if (servletName == null || !servletName.trim().equals("Faces Servlet")) continue;
                addBinding = false;
                break;
            }
        }
        if (addBinding) {
            FilterMapping mapping = this.webApp.addFilterMappingServletName("adfBindings", "Faces Servlet");
            mapping.getDispatchers().add((Object)"FORWARD");
            mapping.getDispatchers().add((Object)"REQUEST");
        }
        this.webApp.getEjbLocalRefs().clear();
        this.webApp.getResourceRefs().clear();
        this.webApp.addServlet("jsp", "oracle.jsp.runtimev2.JspServlet", false);
        String caseFormServletName = "CaseFormServlet";
        Servlet servlet = this.webApp.addServlet(caseFormServletName, "oracle.bpm.casemgmt.client.forms.servlet.CaseFormServlet", false);
        servlet.setLoadOnStartup(Integer.valueOf(2));
        this.webApp.addServletMapping(caseFormServletName, "/" + caseFormServletName);
        this.webApp.createSessionConfig().setSessionTimeout(new Integer(35));
        this.webApp.createMimeMapping("html", "text/html");
        this.webApp.createMimeMapping("text", "text/plain");
        this.webAppNode.commit();
        return true;
    }
}

