/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bpm.casemgmt.ui.common.form.CaseFormProject;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;

public class SelectProjectDialog
extends JEWTDialog {
    private List<CaseFormProject> cfProjList;
    private String helpTopicId = "";
    private SelectProjectPanel selProjPanel;

    public SelectProjectDialog(Frame owner, List<CaseFormProject> cfProjList) {
        super(owner);
        this.cfProjList = cfProjList;
        this.init();
    }

    public CaseFormProject getSelectedProject() {
        if (this.selProjPanel == null) {
            return null;
        }
        return this.selProjPanel.getSelectedProject();
    }

    private void init() {
        String titleText = CaseUiMsg.CASE_FORM_SELECT_EXISTING_PROJECT_TITLE.getString();
        this.selProjPanel = new SelectProjectPanel(this.cfProjList);
        this.setTitle(titleText);
        this.setModal(true);
        this.setPreferredSize(350, 350);
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        this.setButtonMask(1 + 2 + 4);
        this.setOKButtonEnabled(false);
        this.setContent(this.selProjPanel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.selProjPanel, this.helpTopicId);
    }

    private class SelectProjectPanel
    extends JPanel
    implements ListSelectionListener {
        private List<CaseFormProject> cfProjList;
        private JList projListBox;
        private JScrollPane projListScrollPane;
        private MultiLineLabel promptLabel;

        public SelectProjectPanel(List<CaseFormProject> cfProjList) {
            this.cfProjList = cfProjList;
            Collections.sort(cfProjList);
            this.createComponents();
            this.layoutComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.projListBox) {
                if (this.projListBox.getSelectedValue() == null) {
                    SelectProjectDialog.this.setOKButtonEnabled(false);
                } else {
                    SelectProjectDialog.this.setOKButtonEnabled(true);
                }
            }
        }

        protected CaseFormProject getSelectedProject() {
            if (this.projListBox == null) {
                return null;
            }
            return (CaseFormProject)this.projListBox.getSelectedValue();
        }

        private DefaultListModel getProjectListModel() {
            DefaultListModel<CaseFormProject> listModel = new DefaultListModel<CaseFormProject>();
            if (this.cfProjList == null || this.cfProjList.size() < 1) {
                return listModel;
            }
            for (int i = 0; i < this.cfProjList.size(); ++i) {
                CaseFormProject cfProj = this.cfProjList.get(i);
                listModel.addElement(cfProj);
            }
            return listModel;
        }

        private void createComponents() {
            String promptText = CaseUiMsg.CASE_FORM_SELECT_EXISTING_PROJECT_PROMPT.getString();
            this.promptLabel = new MultiLineLabel(promptText);
            this.promptLabel.setTextWrapper(WordWrapper.getTextWrapper());
            DefaultListModel listModel = this.getProjectListModel();
            this.projListBox = new JList(listModel);
            this.projListBox.setSelectionMode(0);
            this.projListBox.setCellRenderer(new ProjectListCellRenderer());
            this.projListBox.addListSelectionListener(this);
            this.projListScrollPane = new JScrollPane(this.projListBox);
        }

        private void layoutComponents() {
            int x = 0;
            int y = 0;
            this.setLayout(new GridBagLayout());
            this.add((Component)this.promptLabel, new GridBagConstraints(x, y, 0, 1, 0.0, 0.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
            this.add((Component)this.projListScrollPane, new GridBagConstraints(x, ++y, 0, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        }
    }

    private class ProjectListCellRenderer
    extends DefaultListCellRenderer {
        private ProjectListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            CaseFormProject cfProj = (CaseFormProject)value;
            if (cfProj.isUsedByCase()) {
                label.setIcon(OracleIcons.getIcon((String)"check.png"));
            } else {
                label.setIcon(OracleIcons.getIcon((String)"project.png"));
            }
            return label;
        }
    }
}

