/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;

public class ProgressDialog
extends JDialog {
    private ProgressPanel progressPanel;

    public ProgressDialog(Frame owner, List<String> stepList) {
        super(owner);
        Dimension dim = new Dimension(325, 300);
        this.progressPanel = new ProgressPanel(stepList);
        this.setModal(true);
        this.setPreferredSize(dim);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.progressPanel);
    }

    public void highlightStep(int stepIndex) {
        this.progressPanel.highlightStep(stepIndex);
    }

    public String getHighlightedStepText() {
        return this.progressPanel.getHighlightedStepText();
    }

    public JButton getCancelButton() {
        if (this.progressPanel == null) {
            return null;
        }
        return this.progressPanel.getCancelButton();
    }

    @Override
    public void dispose() {
        FormGenContext.IS_CASE_DATA_EDITOR = false;
        FormGenContext.IS_CASE_ACTIVITY_EDITOR = false;
        super.dispose();
    }

    private class ProgressPanel
    extends JPanel
    implements ActionListener {
        private Font boldFont;
        private JButton cancelButton;
        private Font plainFont;
        private JProgressBar progressBar;
        private int stepIndex = 0;
        private List<JLabel> stepLabelList;

        public ProgressPanel(List<String> stepTextList) {
            this.layoutControls(stepTextList);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                ProgressDialog.this.dispose();
            }
        }

        protected JButton getCancelButton() {
            return this.cancelButton;
        }

        protected void highlightStep(int stepIndex) {
            if (this.stepLabelList == null) {
                return;
            }
            this.stepIndex = stepIndex;
            this.resetStepFonts();
            this.stepLabelList.get(stepIndex).setFont(this.boldFont);
        }

        protected String getHighlightedStepText() {
            JLabel label = this.stepLabelList.get(this.stepIndex);
            if (label == null) {
                return "";
            }
            return label.getText();
        }

        protected void resetStepFonts() {
            if (this.stepLabelList == null) {
                return;
            }
            for (int i = 0; i < this.stepLabelList.size(); ++i) {
                JLabel curLabel = this.stepLabelList.get(i);
                curLabel.setFont(this.plainFont);
            }
        }

        private void layoutControls(List<String> stepTextList) {
            int x = 0;
            int y = 0;
            String cancelText = "Cancel";
            Font labelFont = UIManager.getFont("Label.font");
            this.plainFont = new Font(labelFont.getName(), 0, labelFont.getSize());
            this.boldFont = new Font(labelFont.getName(), 1, labelFont.getSize());
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            if (stepTextList != null) {
                this.stepLabelList = new ArrayList<JLabel>();
                int i = 0;
                while (i < stepTextList.size()) {
                    JLabel curLabel = new JLabel(stepTextList.get(i));
                    curLabel.setFont(this.plainFont);
                    this.stepLabelList.add(curLabel);
                    y = i++;
                    this.add((Component)curLabel, new GridBagConstraints(x, y, 0, 1, 1.0, 0.0, 18, 1, new Insets(20, 10, 0, 10), 0, 0));
                }
            }
            this.progressBar = new JProgressBar();
            this.progressBar.setIndeterminate(true);
            this.cancelButton = new JButton(cancelText);
            this.cancelButton.addActionListener(this);
            this.add((Component)this.progressBar, new GridBagConstraints(x, ++y, 0, 1, 1.0, 0.0, 18, 1, new Insets(30, 10, 0, 10), 0, 0));
            this.add((Component)this.cancelButton, new GridBagConstraints(x, ++y, 1, 1, 0.0, 1.0, 14, 0, new Insets(10, 10, 10, 10), 0, 0));
        }
    }
}

