/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.ide.log.LogManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

public class FormGenHelper {
    public static final String CASE_TASK_FLOW_LIB = "BPM Case Task Flow";

    public static URL getSchemaUrl(Project project, String schemaPath) throws Exception {
        URL schemaUrl = null;
        if (schemaPath == null) {
            return null;
        }
        if (schemaPath.startsWith("oramds:") || schemaPath.startsWith("http:")) {
            schemaUrl = URLFactory.newURL((String)schemaPath);
            return schemaUrl;
        }
        if (project == null) {
            return null;
        }
        String schemaProjPath = project.getBaseDirectory() + File.separator + schemaPath;
        schemaUrl = URLFactory.newFileURL((String)schemaProjPath);
        return schemaUrl;
    }

    public static String getProjectName(Project project) {
        String shortLabel;
        if (project == null) {
            return null;
        }
        String projectName = shortLabel = project.getShortLabel();
        int index = shortLabel.indexOf(".jpr");
        if (index > 0) {
            projectName = shortLabel.substring(0, index);
        }
        return projectName;
    }

    public static void addLibraries(Project adfProj) {
        if (adfProj == null) {
            return;
        }
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)adfProj);
        JLibrary essLib = JLibraryManager.findLibrary((Object)CASE_TASK_FLOW_LIB);
        if (essLib == null) {
            String[] msgVals = new String[]{CASE_TASK_FLOW_LIB};
            String errMsg = CaseUiMsg.CASE_FORM_LIBRARY_NOT_FOUND.getString();
            MessageFormat msgFormat = new MessageFormat(errMsg);
            errMsg = msgFormat.format(msgVals);
            LogManager.getLogManager().getMsgPage().log((Object)(errMsg + "\n"));
        } else if (projectLibs.addLibrary((Object)essLib)) {
            String[] msgVals = new String[]{CASE_TASK_FLOW_LIB};
            String msg = CaseUiMsg.CASE_FORM_LIBRARY_ADDED.getString();
            MessageFormat msgFormat = new MessageFormat(msg);
            msg = msgFormat.format(msgVals);
            LogManager.getLogManager().getMsgPage().log((Object)(msg + "\n"));
        }
    }

    public static boolean isSimpleType(URL schemaUrl, String elementNamespace, String elementName) {
        if (schemaUrl == null) {
            return false;
        }
        if (elementName == null) {
            return false;
        }
        if (elementNamespace == null) {
            return false;
        }
        try {
            XSDBuilder xsdBuilder = new XSDBuilder();
            XMLSchema schema = xsdBuilder.build(schemaUrl);
            XSDElement element = schema.getElement(elementNamespace, elementName);
            if (element == null) {
                return false;
            }
            XSDNode nodeType = element.getType();
            return nodeType instanceof XSDSimpleType;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Project getProject(Workspace ws, XMLSourceNode xmlSourceNode) {
        if (ws == null) {
            return null;
        }
        if (xmlSourceNode == null) {
            return null;
        }
        Collection projects = ws.projects();
        if (projects == null) {
            return null;
        }
        for (Project curProj : projects) {
            int endIndex;
            String curProjLoc = curProj.getLongLabel();
            String curProjDir = curProjLoc.substring(0, endIndex = curProjLoc.indexOf(curProj.getShortLabel()));
            URL curProjDirUrl = URLFactory.newDirURL((String)curProjDir);
            if (!URLFileSystem.isBaseURLFor((URL)curProjDirUrl, (URL)xmlSourceNode.getURL())) continue;
            return curProj;
        }
        return null;
    }
}

