/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.io.File;
import java.net.URL;
import oracle.adfdt.model.objects.DataControl;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.InputParameter;
import oracle.bpm.casemgmt.model.ca.InputParameterType;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.form.FormGenHelper;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.J2eeSettings;

public class FormGenContext {
    private Project adfProject;
    private Project bpmProject;
    private CaseActivity caseActivity;
    private URL caseActivityUrl;
    private Case caseObj;
    private String caServiceName;
    private URL caseUrl;
    private String compositeName;
    private DataControl dataControl;
    private String dataObjectName;
    private String elementName;
    private String elementNamespace;
    private Context jdevContext;
    private URL schemaUrl;
    private Workspace workspace;
    private String wrapperSchema;
    protected static String XML_EXT = ".xml";
    protected static String JSPX_EXT = ".jspx";
    protected static String DATA_DIR = "data";
    protected static String TASKFLOW_DIR = "tf";
    protected static String VIEW_DIR = "view";
    protected static String ACTIVITY_DIR = "activity";
    public static final String FORM_TYPE_PROPERTY = "formType";
    public static final String CASE_SERVICE_TYPE = "case";
    public static final String CA_FORM_TYPE = "Activity";
    public static final String CD_FORM_TYPE = "Data";
    public static boolean IS_CASE_DATA_EDITOR = false;
    public static boolean IS_CASE_ACTIVITY_EDITOR = false;

    public FormGenContext(Workspace workspace, Case caseObj) {
        this.workspace = workspace;
        this.caseObj = caseObj;
        this.caseActivity = null;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setJdevContext(Context jdevContext) {
        this.jdevContext = jdevContext;
    }

    public Context getJdevContext() {
        return this.jdevContext;
    }

    public Project getAdfProject() {
        return this.adfProject;
    }

    public String getCaseRelativePath() {
        Workspace ws = this.getWorkspace();
        String wsPath = ws.getBaseDirectory();
        URL wsUrl = URLFactory.newDirURL((String)wsPath);
        String caseRelativePath = URLFileSystem.toRelativeSpec((URL)this.caseUrl, (URL)wsUrl);
        return caseRelativePath;
    }

    public void setAdfProject(Project adfProject) {
        this.adfProject = adfProject;
    }

    public Case getCase() {
        return this.caseObj;
    }

    public void setCaseUrl(URL url) {
        this.caseUrl = url;
    }

    public URL getCaseUrl() {
        return this.caseUrl;
    }

    public void setSchemaUrl(String schemaPath) throws Exception {
        this.schemaUrl = FormGenHelper.getSchemaUrl(this.bpmProject, schemaPath);
    }

    public void setSchemaUrl(URL schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public URL getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementNamespace(String elementNamespace) {
        this.elementNamespace = elementNamespace;
    }

    public String getElementNamespace() {
        return this.elementNamespace;
    }

    public void setBpmProject(Project bpmProject) {
        this.bpmProject = bpmProject;
    }

    public Project getBpmProject() {
        return this.bpmProject;
    }

    public void setDataObjectName(String dataObjectName) {
        this.dataObjectName = dataObjectName;
    }

    public String getDataObjectName() {
        return this.dataObjectName;
    }

    public String getCaseName() {
        if (this.caseObj == null) {
            return null;
        }
        return this.caseObj.getName();
    }

    public void setDataControl(DataControl dataControl) {
        this.dataControl = dataControl;
    }

    public DataControl getDataControl() {
        return this.dataControl;
    }

    public void setCompositeName(String compositeName) {
        this.compositeName = compositeName;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public String getFormName() {
        if (this.getCaseActivity() != null) {
            return this.getCaseActivityName();
        }
        return this.getDataObjectName();
    }

    public URL getFormUrl() {
        String formFileName = this.getFormName() + JSPX_EXT;
        if (formFileName == null) {
            return null;
        }
        String formFilePath = this.getFormDir() + formFileName;
        return URLFactory.newFileURL((String)formFilePath);
    }

    public String getTaskFlowName() {
        if (this.getCaseActivity() != null) {
            return this.getCaseActivityName();
        }
        return this.getDataObjectName();
    }

    public String getTaskFlowFileName() {
        String taskFlowName = this.getTaskFlowName();
        if (taskFlowName == null) {
            return null;
        }
        return taskFlowName + XML_EXT;
    }

    public URL getTaskFlowNameUrl() {
        String taskFlowName = this.getTaskFlowName();
        if (taskFlowName == null) {
            return null;
        }
        String taskFlowDir = this.getTaskFlowDir();
        URL taskFlowDirUrl = URLFactory.newDirURL((String)taskFlowDir);
        return URLFactory.newURL((URL)taskFlowDirUrl, (String)taskFlowName);
    }

    public URL getTaskFlowUrl() {
        URL tfNameUrl = this.getTaskFlowNameUrl();
        String tfPath = tfNameUrl.getPath() + XML_EXT;
        return URLFactory.newFileURL((String)tfPath);
    }

    public String getRelativeTaskFlowPath() throws Exception {
        URL tfUrl = this.getTaskFlowUrl();
        Workspace ws = this.getWorkspace();
        String wsPath = ws.getBaseDirectory();
        URL wsUrl = URLFactory.newDirURL((String)wsPath);
        return URLFileSystem.toRelativeSpec((URL)tfUrl, (URL)wsUrl);
    }

    public URL getTaskFlowAbsolutePath(String tfRelPath) {
        if (tfRelPath == null) {
            return null;
        }
        Workspace ws = this.getWorkspace();
        String wsPath = ws.getBaseDirectory();
        String absolutePath = wsPath + "/" + tfRelPath;
        return URLFactory.newFileURL((String)absolutePath);
    }

    public String getTaskFlowDir() {
        if (this.getCaseActivity() == null) {
            URL htmlRootDir = J2eeSettings.getInstance((Project)this.getAdfProject()).getHtmlRootDirectory();
            return URLFileSystem.getPlatformPathName((URL)htmlRootDir) + File.separator + this.getCompositeName() + File.separator + this.getCaseName() + File.separator + DATA_DIR + File.separator + TASKFLOW_DIR + File.separator;
        }
        URL htmlRootDir = J2eeSettings.getInstance((Project)this.getAdfProject()).getHtmlRootDirectory();
        return URLFileSystem.getPlatformPathName((URL)htmlRootDir) + File.separator + this.getCompositeName() + File.separator + this.getCaseName() + File.separator + ACTIVITY_DIR + File.separator + TASKFLOW_DIR + File.separator;
    }

    public String getFormDir() {
        if (this.getCaseActivity() == null) {
            URL htmlRootDir = J2eeSettings.getInstance((Project)this.getAdfProject()).getHtmlRootDirectory();
            return URLFileSystem.getPlatformPathName((URL)htmlRootDir) + File.separator + this.getCompositeName() + File.separator + this.getCaseName() + File.separator + DATA_DIR + File.separator + VIEW_DIR + File.separator;
        }
        URL htmlRootDir = J2eeSettings.getInstance((Project)this.getAdfProject()).getHtmlRootDirectory();
        return URLFileSystem.getPlatformPathName((URL)htmlRootDir) + File.separator + this.getCompositeName() + File.separator + this.getCaseName() + File.separator + ACTIVITY_DIR + File.separator + VIEW_DIR + File.separator;
    }

    public void setCaseActivity(CaseActivity caseActivity) {
        this.caseActivity = caseActivity;
    }

    public CaseActivity getCaseActivity() {
        return this.caseActivity;
    }

    public void setCaseActivityUrl(URL caseActivityUrl) {
        this.caseActivityUrl = caseActivityUrl;
    }

    public URL getCaseActivityUrl() {
        return this.caseActivityUrl;
    }

    public void setWrapperSchema(String wrapperSchema) {
        this.wrapperSchema = wrapperSchema;
    }

    public String getWrapperSchema() {
        return this.wrapperSchema;
    }

    public void setCaseActivityServiceName(String serviceName) {
        this.caServiceName = serviceName;
    }

    public String getCaseActivityServiceName() {
        return this.caServiceName;
    }

    public String getCaseActivityName() {
        if (this.getCaseActivity() == null) {
            return null;
        }
        return this.getCaseActivity().getName();
    }

    public String getCaseActivityRelativePath() {
        Workspace ws = this.getWorkspace();
        String wsPath = ws.getBaseDirectory();
        URL wsUrl = URLFactory.newDirURL((String)wsPath);
        String caseRelativePath = URLFileSystem.toRelativeSpec((URL)this.caseActivityUrl, (URL)wsUrl);
        return caseRelativePath;
    }

    public URL getWrapperSchemaUrl() {
        if (this.wrapperSchema == null) {
            return null;
        }
        return URLFactory.newFileURL((String)this.wrapperSchema);
    }

    public boolean caseActivityHasUserInputType() {
        if (this.getCaseActivity() == null) {
            return false;
        }
        Activity activity = this.getCaseActivity().getActivity();
        if (activity == null) {
            return false;
        }
        InputParameters inputParams = activity.getInputParameters();
        if (inputParams == null) {
            return false;
        }
        for (InputParameter inputParam : inputParams) {
            InputParameterType inputParamType = inputParam.getType();
            if (inputParamType == null || !inputParamType.isPayload()) continue;
            return true;
        }
        return false;
    }

    public void print() {
        System.out.println("\n\nForm Generation Context");
        System.out.println("-----------------------");
        System.out.println("BPM Project: " + this.getBpmProject().getBaseDirectory());
        System.out.println("ADF Project: " + this.getAdfProject().getBaseDirectory());
        if (this.getSchemaUrl() != null) {
            System.out.println("Schema URL: " + this.getSchemaUrl().toString());
        }
        System.out.println("Schema Element Namespace: " + this.getElementNamespace());
        System.out.println("Schema Element Name: " + this.getElementName());
        System.out.println("Case Name: " + this.getCaseName());
        System.out.println("Workspace URL: " + this.getWorkspace().getURL().toString());
        if (this.getCaseUrl() != null) {
            System.out.println("Case URL: " + this.getCaseUrl());
            System.out.println("Case Relative Path: " + this.getCaseRelativePath());
        }
        System.out.println("Composite Name: " + this.getCompositeName());
        System.out.println("-----------------------\n\n");
    }
}

