/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.common.util.Jaxb20ContextFactory;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlowType;
import oracle.bpm.casemgmt.client.forms.model.CaseTaskFlows;
import oracle.bpm.casemgmt.client.forms.model.ObjectFactory;
import oracle.bpm.casemgmt.ui.common.form.FormGenContext;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.J2eeSettings;

public class CaseTaskFlowXmlHelper {
    private static final String CASE_TASK_FLOW_XML = "caseTaskflow.xml";
    private static final String RELATIVE_PATH = "/adfmsrc/";

    public static Marshaller getMarshaller() throws Exception {
        return Jaxb20ContextFactory.getJAXBContext((String)"oracle.bpm.casemgmt.client.forms.model").createMarshaller();
    }

    public static Unmarshaller getUnMarshaller() throws Exception {
        return Jaxb20ContextFactory.getJAXBContext((String)"oracle.bpm.casemgmt.client.forms.model").createUnmarshaller();
    }

    public void createCaseFlowXml(FormGenContext formGenCtx) throws Exception {
        if (formGenCtx == null) {
            return;
        }
        if (formGenCtx.getAdfProject() == null) {
            return;
        }
        String ctfXmlDirPath = formGenCtx.getAdfProject().getBaseDirectory() + RELATIVE_PATH;
        String caseTaskFlowXmlPath = ctfXmlDirPath + CASE_TASK_FLOW_XML;
        URL caseTaskFlowXmlUrl = URLFactory.newFileURL((String)caseTaskFlowXmlPath);
        URL htmlUrl = J2eeSettings.getInstance((Project)formGenCtx.getAdfProject()).getHtmlRootDirectory();
        URL taskFlowUrl = formGenCtx.getTaskFlowUrl();
        String relativeTaskFlowPath = URLFileSystem.toRelativeSpec((URL)taskFlowUrl, (URL)htmlUrl);
        File ctfXmlDir = new File(ctfXmlDirPath);
        ctfXmlDir.mkdirs();
        OutputStream outputStream = null;
        try {
            Unmarshaller um;
            File caseTaskFlowXmlFile = new File(caseTaskFlowXmlUrl.getPath());
            CaseTaskFlows caseTaskFlows = null;
            if (!caseTaskFlowXmlFile.exists()) {
                caseTaskFlowXmlFile.createNewFile();
                this.createTopLevelElements(caseTaskFlowXmlFile);
            }
            if ((caseTaskFlows = (CaseTaskFlows)(um = CaseTaskFlowXmlHelper.getUnMarshaller()).unmarshal(caseTaskFlowXmlFile)) == null) {
                this.createTopLevelElements(caseTaskFlowXmlFile);
                caseTaskFlows = (CaseTaskFlows)um.unmarshal(caseTaskFlowXmlFile);
            }
            Marshaller m = CaseTaskFlowXmlHelper.getMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            ObjectFactory objectFactory = new ObjectFactory();
            CaseTaskFlowType caseTaskFlowType = objectFactory.createCaseTaskFlowType();
            caseTaskFlowType.setCaseName(formGenCtx.getCaseName());
            if (formGenCtx.getCaseActivity() != null) {
                caseTaskFlowType.setCaseItemName(formGenCtx.getCaseActivity().getName());
                caseTaskFlowType.setCaseDefinitionId(formGenCtx.getCaseActivity().getName());
            } else {
                caseTaskFlowType.setCaseItemName(formGenCtx.getDataObjectName());
            }
            caseTaskFlowType.setCaseDefinitionNamespace(formGenCtx.getCase().getTargetNamespace());
            caseTaskFlowType.setTaskFlowId(formGenCtx.getTaskFlowName());
            caseTaskFlowType.setTaskFlowFileName(relativeTaskFlowPath);
            List caseTaskFlowList = caseTaskFlows.getCaseTaskFlow();
            caseTaskFlowList.add(caseTaskFlowType);
            outputStream = URLFileSystem.openOutputStream((URL)caseTaskFlowXmlUrl);
            m.marshal((Object)caseTaskFlows, outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void createTopLevelElements(File caseTaskFlowXmlFile) throws Exception {
        if (caseTaskFlowXmlFile == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            Marshaller m = CaseTaskFlowXmlHelper.getMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            CaseTaskFlows caseTaskFlows = null;
            ObjectFactory objectFactory = new ObjectFactory();
            caseTaskFlows = objectFactory.createCaseTaskFlows();
            caseTaskFlows.setApplicationName("worklist");
            caseTaskFlows.setCaseTaskFlowDeploy(Boolean.valueOf(false));
            URL caseTaskFlowXmlUrl = caseTaskFlowXmlFile.toURI().toURL();
            outputStream = URLFileSystem.openOutputStream((URL)caseTaskFlowXmlUrl);
            m.marshal((Object)caseTaskFlows, outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
}

