/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common.form;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.bpm.casemgmt.ui.common.form.DataControlUiObj;
import oracle.bpm.casemgmt.ui.common.form.FormGenHelper;
import oracle.ide.model.Project;

public class CaseFormProject
implements Comparable {
    private Project adfProject;
    private Properties caseFormProps;
    private String caseName;
    private List<DataControlUiObj> dataControlList;
    private boolean isUsedByCase;
    private String projectName;
    private List<String> taskFlowPathList;
    public static final String PROPERTIES_FILE_NAME = "case_form.properties";
    public static final String DC_NAMES_PROPERTY = "dc_names";
    public static final String TF_PATHS_PROPERTY = "tf_paths";
    public static final String DELIMITER = ";";

    public CaseFormProject(Project adfProject, String caseName) {
        this.adfProject = adfProject;
        this.caseName = caseName;
        this.isUsedByCase = false;
        this.init();
    }

    public Project getAdfProject() {
        return this.adfProject;
    }

    public List<DataControlUiObj> getDataControlList() {
        return this.dataControlList;
    }

    public String getName() {
        return this.projectName;
    }

    public boolean isUsedByCase() {
        return this.isUsedByCase;
    }

    public String getCaseName() {
        return this.caseName;
    }

    public String toString() {
        return this.projectName;
    }

    public String getTaskFlowPath(String taskFlowFileName) {
        if (taskFlowFileName == null) {
            return null;
        }
        if (this.taskFlowPathList == null || this.taskFlowPathList.size() < 1) {
            return null;
        }
        for (int i = 0; i < this.taskFlowPathList.size(); ++i) {
            String curTFPath = this.taskFlowPathList.get(i);
            if (!curTFPath.endsWith(taskFlowFileName)) continue;
            return curTFPath;
        }
        return null;
    }

    public int compareTo(Object o) {
        CaseFormProject cfProj = (CaseFormProject)o;
        if (this.isUsedByCase() && !cfProj.isUsedByCase()) {
            return -1;
        }
        if (!this.isUsedByCase() && cfProj.isUsedByCase()) {
            return 1;
        }
        return 0;
    }

    private void init() {
        try {
            String propFilePath;
            File csPropFile;
            this.projectName = FormGenHelper.getProjectName(this.adfProject);
            this.caseFormProps = new Properties();
            if (this.adfProject != null && (csPropFile = new File(propFilePath = this.adfProject.getBaseDirectory() + File.separator + PROPERTIES_FILE_NAME)).exists()) {
                this.caseFormProps.load(new FileInputStream(propFilePath));
                String dcPropVal = this.caseFormProps.getProperty(DC_NAMES_PROPERTY);
                this.initDataControlList(dcPropVal);
                String tfPropVal = this.caseFormProps.getProperty(TF_PATHS_PROPERTY);
                this.initTaskFlowPathList(tfPropVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isUsedByCase(DataControlUiObj dc) {
        if (dc == null) {
            return false;
        }
        return this.caseName.equals(dc.getCaseName());
    }

    private void initDataControlList(String propVal) {
        this.dataControlList = new ArrayList<DataControlUiObj>();
        if (propVal == null) {
            return;
        }
        StringTokenizer propValTokenizer = new StringTokenizer(propVal, DELIMITER);
        while (propValTokenizer.hasMoreElements()) {
            String val = (String)propValTokenizer.nextElement();
            int index = val.indexOf(":");
            if (index <= 0) continue;
            String dcName = val.substring(0, index);
            String caseName = val.substring(index + 1, val.length());
            DataControlUiObj dc = new DataControlUiObj();
            dc.setDataControlName(dcName);
            dc.setCaseName(caseName);
            this.dataControlList.add(dc);
            if (this.isUsedByCase) continue;
            this.isUsedByCase = this.isUsedByCase(dc);
        }
    }

    private void initTaskFlowPathList(String tfPropVal) {
        this.taskFlowPathList = new ArrayList<String>();
        if (tfPropVal == null) {
            return;
        }
        StringTokenizer propValTokenizer = new StringTokenizer(tfPropVal, DELIMITER);
        while (propValTokenizer.hasMoreElements()) {
            String val = (String)propValTokenizer.nextElement();
            this.taskFlowPathList.add(val);
        }
    }
}

