/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.ui.common.NoEmptyStringTableCellRenderer;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.lang.Any;

public class I18nTableCellRenderer
extends NoEmptyStringTableCellRenderer {
    private PropertyBundle bundle;
    private List<Object> values;
    private static final long serialVersionUID = 3471538620802750845L;

    protected I18nTableCellRenderer(PropertyBundle bundle) {
        this.bundle = bundle;
    }

    public static I18nTableCellRenderer create(PropertyBundle bundle) {
        return new I18nTableCellRenderer(bundle);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.values = this.createValues(table, column);
        JLabel result = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String key = (String)value;
        if (this.bundle.containsKey((Object)key)) {
            this.setText((String)this.bundle.get((Object)key));
            if (this.error(key) == null) {
                this.setToolTipText(key);
            }
        } else {
            this.setText("[" + key + "]");
        }
        return result;
    }

    @Override
    protected String error(String value) {
        String error = super.error(value);
        if (error == null) {
            if (this.isDuplicated(value)) {
                error = CaseUiMsg.ERROR_DUPLICATED_NAME.getString();
            } else if (!this.bundle.containsKey((Object)value)) {
                error = CaseUiMsg.ERROR_MISSING_TRANSLATION.getString();
            }
        }
        return error;
    }

    private List<Object> createValues(JTable table, int column) {
        ArrayList<Object> result = new ArrayList<Object>();
        int rows = table.getRowCount();
        for (int row = 0; row < rows; ++row) {
            result.add(table.getValueAt(row, column));
        }
        return result;
    }

    private boolean isDuplicated(String value) {
        int instances = 0;
        for (Object object : this.values) {
            if (!Any.equals(value, object)) continue;
            ++instances;
        }
        return instances > 1;
    }
}

