/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common;

import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;

public abstract class AbstractEntityPanel<E>
extends Panel
implements EntityEvents {
    private E model;

    public AbstractEntityPanel(UiContainer parent, E model) {
        super(parent);
        this.model = model;
    }

    public static void dumpEvents(Event ... events) {
        for (Event event : events) {
            AbstractEntityPanel.dumpEvent(event, "");
        }
    }

    protected E getEntityModel() {
        return this.model;
    }

    private static void dumpEvent(Event event, String tab) {
        EventType type = event.getType();
        Entity object = event.getObject();
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        Attr attr = event.getAttr();
        String newValueText = newValue != null ? newValue.getClass().getSimpleName() : "NULL";
        String oldValueText = oldValue != null ? oldValue.getClass().getSimpleName() : "NULL";
        System.out.println(tab + "" + "Type:" + type.name() + " Attr:" + attr.getId() + " Object:" + object.getClass().getSimpleName() + " NewValue:" + newValueText + " OldValue:" + oldValueText);
        Event childEvent = event.getChildEvent();
        if (childEvent != null) {
            AbstractEntityPanel.dumpEvent(childEvent, tab + "  ");
        }
    }
}

