/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventListener;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.Ide;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;

public abstract class AbstractEntityNode<E extends Entity>
extends XMLSourceNode {
    private EventListener listener;
    private E model;
    private Project project;
    private TextBuffer textBuffer;

    public E getEntityModel() {
        if (this.model == null && this.getBpmProject() != null) {
            try {
                this.model = this.loadEntityModel();
                if (this.model != null) {
                    this.ensureOpen();
                    this.startListening();
                }
            }
            catch (IOException e) {
                MessageDialog.showError(e);
            }
        }
        return this.model;
    }

    public final void saveAndCloseEditor() throws IOException {
        this.save();
        this.closeEditor();
    }

    public final void closeEditor() {
        ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
        List editors = EditorManager.getEditorManager().getAllEditors();
        for (Object object : editors) {
            Editor editor = (Editor)object;
            Node editorNode = editor.getContext().getNode();
            if (this != editorNode) continue;
            editorsToClose.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(editorsToClose);
    }

    public String getShortLabel() {
        URL url = this.getURL();
        String result = url != null ? URLFileSystem.getName((URL)url) : super.getShortLabel();
        return result;
    }

    protected abstract E loadEntityModel() throws IOException;

    protected abstract void saveEntityModel() throws IOException;

    protected abstract void revertEntityModel();

    protected void openImpl() throws IOException {
        super.openImpl();
        this.textBuffer = this.acquireTextBuffer();
    }

    protected void saveImpl() throws IOException {
        if (this.model != null) {
            this.saveEntityModel();
        }
    }

    protected void closeImpl() throws IOException {
        this.stopListening();
        this.model = null;
        this.textBuffer = null;
        this.releaseTextBuffer();
        super.closeImpl();
        if (this.isDirty()) {
            this.revertEntityModel();
            this.fireReplaceObject();
        }
    }

    protected Project getProject() {
        if (this.project == null) {
            URL nodeUrl = this.getURL();
            Workspace workspace = this.getWorkspace();
            Collection projects = workspace.projects();
            for (Project p : projects) {
                URL jprUrl = p.getURL();
                URL projectUrl = URLFileSystem.getParent((URL)jprUrl);
                if (!URLFileSystem.isBaseURLFor((URL)projectUrl, (URL)nodeUrl)) continue;
                this.project = p;
                break;
            }
        }
        return this.project;
    }

    protected oracle.bpm.project.model.Project getBpmProject() {
        oracle.bpm.project.model.Project result = null;
        Project jdevProject = this.getProject();
        if (jdevProject != null) {
            JdevRepositoryService service = JdevRepositoryService.getInstance();
            result = service.getProject(jdevProject);
        }
        return result;
    }

    private void fireReplaceObject() {
        UpdateMessage message1 = new UpdateMessage(UpdateMessage.CHILD_RENAMED, (Object)this);
        this.notifyObservers((Object)this, message1);
        UpdateMessage message = new UpdateMessage(UpdateMessage.ATTRIBUTE_CHANGED, (Object)this);
        this.notifyObservers((Object)this, message);
    }

    private void startListening() {
        if (this.listener == null) {
            this.listener = new EventListener(){

                public void onEvent(Event ... events) {
                    AbstractEntityNode.this.markDirty(true);
                    IdeActions.getFileSaveAction().updateAction();
                }
            };
        }
        this.model.addListener(this.listener, new Attr[0]);
    }

    private void stopListening() {
        if (this.model != null) {
            this.model.removeListener(this.listener, new Attr[0]);
        }
    }

    private Workspace getWorkspace() {
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace == null) {
            Iterator iterator = NodeFactory.getCachedNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Workspace)) continue;
                workspace = (Workspace)node;
                break;
            }
        }
        return workspace;
    }
}

