/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.common;

import java.awt.Component;
import java.net.URL;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.attributes.Attr;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventListener;
import oracle.bpm.draw.Color;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;

public abstract class AbstractEntityEditor<E extends Entity>
extends Editor {
    protected TabbedPane tabbedPane;
    private EventListener listener;
    private E model;

    public void open() {
    }

    public synchronized void setContext(Context context) {
        if (this.model == null) {
            this.model = this.getEntityModel(context);
            if (this.model == null) {
                super.setContext(context);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEntityEditor.this.closeEditor();
                    }
                });
            } else {
                this.startListener();
            }
        }
        super.setContext(context);
    }

    public Component getGUI() {
        try {
            if (this.tabbedPane == null && this.isValidModels()) {
                this.tabbedPane = AbstractEntityEditor.createTabbedPane(UiContainer.NULL);
                this.addTabs(this.tabbedPane);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return this.tabbedPane != null ? this.tabbedPane.asSwing() : new JLabel(this.model == null ? "Invalid Model" : "There is no BPM Project for JDev Project");
    }

    public void close() {
        super.close();
        this.stopListener();
        this.model = null;
    }

    public void update(Object o, UpdateMessage updateMessage) {
    }

    protected abstract E getEntityModel(Context var1);

    protected abstract void addTabs(TabbedPane var1);

    protected boolean isValidModels() {
        return this.model != null && this.getBpmProject() != null;
    }

    protected E getEntityModel() {
        return this.model;
    }

    protected String getHeaderName() {
        Node node = this.getContext().getNode();
        URL url = node != null ? node.getURL() : null;
        return url != null ? URLFileSystem.getName((URL)url) : this.getTabDescription();
    }

    protected oracle.bpm.project.model.Project getBpmProject() {
        Project project = this.getContext().getProject();
        return project != null ? this.getBpmProject(project) : null;
    }

    protected void fireModelChanged(Event ... events) {
        if (this.tabbedPane != null) {
            int tabCount = this.tabbedPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                UiComponent uiComponent = this.tabbedPane.getComponentAt(i);
                if (!(uiComponent instanceof EntityEvents)) continue;
                ((EntityEvents)((Object)uiComponent)).modelChanged(events);
            }
        }
    }

    private static TabbedPane createTabbedPane(UiContainer parent) {
        TabbedPane result = new TabbedPane(parent);
        result.putClientProperty("inherit.background.color", Color.WHITE);
        JTabbedPane jTabbedPane = (JTabbedPane)result.asSwing();
        jTabbedPane.setUI((TabbedPaneUI)new FlatTabbedPaneUI());
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return result;
    }

    private void startListener() {
        this.listener = new EventListener(){

            public void onEvent(Event ... events) {
                AbstractEntityEditor.this.fireModelChanged(events);
            }
        };
        this.model.addListener(this.listener, new Attr[0]);
    }

    private void stopListener() {
        if (this.model != null) {
            this.model.removeListener(this.listener, new Attr[0]);
        }
    }

    private void closeEditor() {
        EditorManager.getEditorManager().closeEditors(Collections.singletonList(this));
    }

    private oracle.bpm.project.model.Project getBpmProject(Project project) {
        return JdevRepositoryService.getInstance().getProject(project);
    }
}

