/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.cm.CaseNode;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.ui.Image;
import oracle.ide.Context;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ideimpl.explorer.BaseTreeExplorer;

public class CaseStructureExplorer
extends BaseTreeExplorer {
    private static final Icon ICON = Image.create(CaseUiMsg.CASE).asSwingIcon();

    protected Element annotate(Context context) {
        CaseNode node;
        Case aCase;
        DefaultFolder root = null;
        if (context != null && context.getNode() instanceof CaseNode && (aCase = (Case)(node = (CaseNode)context.getNode()).getEntityModel()) != null) {
            root = this.getRootCaseElementAdapter(aCase);
        }
        return root != null ? root : new DefaultFolder();
    }

    private Element getRootCaseElementAdapter(Case casemgmt) {
        return new RootCaseElementAdapter(casemgmt);
    }

    public class RootCaseElementAdapter
    extends DefaultElement {
        private List<CaseElementAdapter> children = new ArrayList<CaseElementAdapter>();

        public RootCaseElementAdapter(Case casemgmt) {
            this.children.add(new CaseElementAdapter("Milestones"));
            this.children.add(new CaseElementAdapter("Events"));
            this.children.add(new CaseElementAdapter("Case Owner"));
            this.children.add(new CaseElementAdapter("Case Worker"));
        }

        public String getShortLabel() {
            return "Root";
        }

        public boolean mayHaveChildren() {
            return !this.children.isEmpty();
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }
    }

    public class CaseElementAdapter
    extends DefaultElement {
        private String name;

        public CaseElementAdapter(String name) {
            this.name = name;
        }

        public String getShortLabel() {
            return this.name;
        }

        public Icon getIcon() {
            return ICON;
        }
    }
}

