/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.form.databinding.binder;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.adfdt.ADFDesignTimeContext;
import oracle.adfdt.model.objects.DataControl;
import oracle.adfdt.view.common.binding.creator.Binder;
import oracle.adfdt.view.common.binding.creator.CreationContext;
import oracle.adfdt.view.common.binding.creator.v2.CreatorParams;
import oracle.adfdt.view.common.binding.creator.v2.CreatorResult;
import oracle.adfdt.view.common.binding.provider.ModelProvider;
import oracle.adfdt.view.common.binding.standalone.Widget;
import oracle.adfdt.view.common.binding.standalone.WidgetFactory;
import oracle.adfdt.view.common.binding.utils.ADFBindingUtils;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.bpm.casemgmt.ui.cm.form.databinding.provider.CasePayloadModelProvider;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CasePayloadBinder
implements Binder {
    private CreationContext creationCtx;
    private DataControl dataControl;
    private ADFDesignTimeContext designTimeCtx;
    private Element emptyPanelGroupLayout;
    private CasePayloadModelProvider modelProvider;
    private Element outputTextElem;
    private Element panelFormLayoutRoot;
    private Element panelGroupLayoutRoot;
    private static final String STYLE = "font-family:Tahoma, Verdana, Helvetica, sans-serif;font-size:11px;font-weight:bold;display:inline;margin:0px;white-space:nowrap;color:#3E403D";
    static MyNSResolver nsr = new MyNSResolver();

    public void bind(ADFDesignTimeContext aDFDesignTimeContext, CreationContext creationContext, ModelProvider modelProvider, Node node, Element element, Map map) {
        this.designTimeCtx = aDFDesignTimeContext;
        this.creationCtx = creationContext;
        this.modelProvider = (CasePayloadModelProvider)modelProvider;
        NamedDefinition definition = this.modelProvider.getDefinition();
        if (definition != null && 50 == definition.getDefinitionType()) {
            this.dataControl = this.modelProvider.getDataControl();
            if (this.dataControl == null) {
                return;
            }
            try {
                this.panelGroupLayoutRoot = this.getPanelGroupLayoutRoot(element);
                this.panelGroupLayoutRoot.removeAttribute("id");
                this.emptyPanelGroupLayout = (Element)this.panelGroupLayoutRoot.cloneNode(false);
                this.panelFormLayoutRoot = this.getPanelFormLayoutRoot(this.panelGroupLayoutRoot);
                this.outputTextElem = this.getPanelHeaderTextElement();
                this.insertFormElements();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean canRebind(Node node, Element element) {
        return false;
    }

    private Element getPanelGroupLayoutRoot(Element root) throws Exception {
        root = (Element)root.getParentNode();
        XMLElement xmlRoot = (XMLElement)root;
        String xpath = "//af:panelGroupLayout[@id='plPnl76']";
        return (Element)xmlRoot.selectSingleNode(xpath, (NSResolver)nsr);
    }

    private Element getPanelFormLayoutRoot(Element panelGroupLayoutRoot) throws Exception {
        if (panelGroupLayoutRoot == null) {
            return null;
        }
        Element panelFormLayoutRoot = (Element)panelGroupLayoutRoot.getFirstChild();
        return panelFormLayoutRoot;
    }

    private Element getPanelHeaderTextElement() {
        if (this.dataControl == null) {
            return null;
        }
        StructureDefinition strucDef = this.dataControl.getDataControlDefinition().getStructure();
        if (strucDef == null) {
            return null;
        }
        DefinitionContainer attribDefContainer = strucDef.getAttributeDefinitions();
        if (attribDefContainer == null) {
            return null;
        }
        for (AttributeDefinition curAttribDef : attribDefContainer) {
            Element outputTextElem = this.getOutputTextElement(curAttribDef);
            if (outputTextElem == null) continue;
            return outputTextElem;
        }
        DefinitionContainer accessorDefContainer = strucDef.getAccessorDefinitions();
        if (accessorDefContainer == null) {
            return null;
        }
        for (AccessorDefinition acDef : accessorDefContainer) {
            Element outputTextElem = this.getPanelHeaderTextElement(acDef);
            if (outputTextElem == null) continue;
            return outputTextElem;
        }
        return null;
    }

    private Element getPanelHeaderTextElement(AccessorDefinition accessorDef) {
        DefinitionContainer accessorContainer;
        if (accessorDef == null) {
            return null;
        }
        StructureDefinition strucDef = ADFBindingUtils.getStructureDefinition((Definition)accessorDef);
        if (strucDef == null) {
            return null;
        }
        DefinitionContainer attribContainer = strucDef.getAttributeDefinitions();
        if (attribContainer != null) {
            for (AttributeDefinition curAttribDef : attribContainer) {
                Element outputTextElem = this.getOutputTextElement(curAttribDef);
                if (outputTextElem == null) continue;
                return outputTextElem;
            }
        }
        if ((accessorContainer = strucDef.getAccessorDefinitions()) != null) {
            for (AccessorDefinition curAccessorDef : accessorContainer) {
                Element outputTextElem = this.getPanelHeaderTextElement(curAccessorDef);
                if (outputTextElem == null) continue;
                return outputTextElem;
            }
        }
        return null;
    }

    private Element getOutputTextElement(AttributeDefinition attribDef) {
        if (attribDef == null) {
            return null;
        }
        WidgetFactory.WidgetFactoryContext widgetFactoryCtx = WidgetFactory.createContext((ADFDesignTimeContext)this.designTimeCtx, (DataControl)this.dataControl, (NamedDefinition)attribDef);
        Map widgetMap = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)widgetFactoryCtx);
        Widget outputTextWidget = (Widget)widgetMap.get("outputtext_adf_faces");
        if (outputTextWidget == null) {
            return null;
        }
        CreatorParams creatorParams = outputTextWidget.createBaseCreatorParams(null);
        CreatorResult creatorResult = outputTextWidget.create(creatorParams);
        DocumentFragment docFrag = creatorResult.getFragment();
        return (Element)docFrag.getFirstChild();
    }

    private void insertFormElements() {
        DefinitionContainer accessorDefContainer;
        if (this.dataControl == null) {
            return;
        }
        StructureDefinition strucDef = this.dataControl.getDataControlDefinition().getStructure();
        if (strucDef == null) {
            return;
        }
        DefinitionContainer attribDefContainer = strucDef.getAttributeDefinitions();
        if (attribDefContainer != null) {
            boolean inserted = false;
            for (AttributeDefinition attribDef : attribDefContainer) {
                this.insertTextInput(attribDef, this.panelFormLayoutRoot);
                inserted = true;
            }
            if (!inserted) {
                this.panelGroupLayoutRoot.removeChild(this.panelFormLayoutRoot);
            }
        }
        if ((accessorDefContainer = strucDef.getAccessorDefinitions()) != null) {
            for (AccessorDefinition acDef : accessorDefContainer) {
                if (acDef.isCollection()) {
                    this.insertTable(acDef, this.panelGroupLayoutRoot);
                    continue;
                }
                this.insertComplexType(acDef, this.panelGroupLayoutRoot);
            }
        }
    }

    private void insertInputForm(AccessorDefinition accessorDef, Element parent) {
        CreatorParams creatorParams;
        String formADFFaces;
        if (accessorDef == null) {
            return;
        }
        if (parent == null) {
            return;
        }
        WidgetFactory.WidgetFactoryContext widgetFactoryCtx = WidgetFactory.createContext((ADFDesignTimeContext)this.designTimeCtx, (DataControl)this.dataControl, (NamedDefinition)accessorDef);
        Map widgetMap = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)widgetFactoryCtx);
        Widget outputTextWidget = (Widget)widgetMap.get(formADFFaces = "form_adf_faces");
        CreatorResult creatorResults = outputTextWidget.create(creatorParams = outputTextWidget.createBaseCreatorParams(null));
        DocumentFragment docFrag = creatorResults.getFragment();
        Element formElem = (Element)docFrag.getFirstChild();
        NodeList nl = formElem.getElementsByTagNameNS("http://java.sun.com/jsf/core", "facet");
        if (nl != null && nl.getLength() > 0) {
            formElem.removeChild(nl.item(0));
        }
        parent.appendChild(formElem);
    }

    private void insertTextInput(AttributeDefinition attribDef, Element parent) {
        Widget outputTextWidget;
        if (attribDef == null) {
            return;
        }
        if (parent == null) {
            return;
        }
        WidgetFactory.WidgetFactoryContext widgetFactoryCtx = WidgetFactory.createContext((ADFDesignTimeContext)this.designTimeCtx, (DataControl)this.dataControl, (NamedDefinition)attribDef);
        Map widgetMap = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)widgetFactoryCtx);
        String inputPattern = "inputtext_with_label_adf_faces";
        if (attribDef.getJavaTypeString().equals("java.util.Date")) {
            inputPattern = "inputdate_with_label_adf_faces";
        }
        if ((outputTextWidget = (Widget)widgetMap.get(inputPattern)) != null) {
            CreatorParams creatorParams = outputTextWidget.createBaseCreatorParams(null);
            CreatorResult creatorResult = outputTextWidget.create(creatorParams);
            DocumentFragment docFrag = creatorResult.getFragment();
            Element formElem = (Element)docFrag.getFirstChild();
            parent.appendChild(formElem);
        }
    }

    private void insertComplexType(AccessorDefinition accessorDef, Element parent) {
        DefinitionContainer accessorContainer;
        if (accessorDef == null) {
            return;
        }
        if (parent == null) {
            return;
        }
        StructureDefinition strucDef = accessorDef.getStructure();
        if (strucDef == null) {
            return;
        }
        DefinitionContainer attribContainer = strucDef.getAttributeDefinitions();
        if (attribContainer != null) {
            Element panelLayout = null;
            Iterator attribItor = attribContainer.iterator();
            if (attribItor.hasNext()) {
                String name = this.getPanelTitle(accessorDef);
                panelLayout = this.createPanelGroupLayout(name, parent);
                this.insertInputForm(accessorDef, panelLayout);
            }
        }
        if ((accessorContainer = strucDef.getAccessorDefinitions()) != null) {
            for (AccessorDefinition childAccessorDef : accessorContainer) {
                if (childAccessorDef.isCollection()) {
                    this.insertTable(childAccessorDef, parent);
                    continue;
                }
                this.insertComplexType(childAccessorDef, parent);
            }
        }
    }

    private void insertTable(AccessorDefinition accessorDef, Element parent) {
        StructureDefinition msgStructDef = ADFBindingUtils.getStructureDefinition((Definition)accessorDef);
        if (msgStructDef != null) {
            DefinitionContainer attrContainer = msgStructDef.getAttributeDefinitions();
            Iterator msgFieldDefinitions = attrContainer.iterator();
            if (!msgFieldDefinitions.hasNext()) {
                return;
            }
            String name = this.getPanelTitle(accessorDef);
            Element titlePanel = this.createPanelGroupLayout(name, parent);
            this.createButtons(titlePanel, accessorDef);
            parent.appendChild(titlePanel);
            Element tablePanel = (Element)this.emptyPanelGroupLayout.cloneNode(false);
            titlePanel.appendChild(tablePanel);
            WidgetFactory.WidgetFactoryContext widgetFactoryCtx = WidgetFactory.createContext((ADFDesignTimeContext)this.designTimeCtx, (DataControl)this.dataControl, (NamedDefinition)accessorDef);
            Map widgetMap = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)widgetFactoryCtx);
            Widget tableWidget = (Widget)widgetMap.get("custom_table_adf_faces");
            if (tableWidget != null) {
                CreatorParams creatorParams = tableWidget.createBaseCreatorParams(null);
                CreatorResult creatorResult = tableWidget.create(creatorParams);
                DocumentFragment docFrag = creatorResult.getFragment();
                Element tableElem = (Element)docFrag.getFirstChild();
                tablePanel.appendChild(tableElem);
            }
        }
    }

    private void createButtons(Element parent, AccessorDefinition accessorDef) {
        try {
            Element panelLayout = (Element)this.emptyPanelGroupLayout.cloneNode(false);
            panelLayout.setAttribute("layout", "horizontal");
            parent.appendChild(panelLayout);
            StructureDefinition strucDef = ADFBindingUtils.getCollectionStructureDefinition((Definition)accessorDef);
            if (strucDef != null) {
                Element buttonPanel = panelLayout;
                DefinitionContainer opContainer = strucDef.getOperationDefinitions();
                for (OperationDefinition opDef : opContainer) {
                    WidgetFactory.WidgetFactoryContext widgetFactoryCtx;
                    Map widgetMap;
                    Widget button;
                    if (!opDef.getName().equalsIgnoreCase("Create") && !opDef.getName().equalsIgnoreCase("Delete") || (button = (Widget)(widgetMap = WidgetFactory.getAvailableWidgets((WidgetFactory.WidgetFactoryContext)(widgetFactoryCtx = WidgetFactory.createContext((ADFDesignTimeContext)this.designTimeCtx, (DataControl)this.dataControl, (NamedDefinition)opDef)))).get("commandbutton_adf_faces")) == null) continue;
                    CreatorParams creatorParams = button.createBaseCreatorParams(null);
                    CreatorResult creatorResult = button.create(creatorParams);
                    DocumentFragment docFrag = creatorResult.getFragment();
                    Element buttonElem = (Element)docFrag.getFirstChild();
                    buttonPanel.appendChild(buttonElem);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPanelTitle(AccessorDefinition accessorDef) {
        String title = "";
        if (accessorDef == null) {
            return title;
        }
        for (AccessorDefinition parentAccessor = accessorDef.getParentAccessor(); parentAccessor != null; parentAccessor = parentAccessor.getParentAccessor()) {
            title = title.equals("") ? parentAccessor.getName() : title + " - " + parentAccessor.getName();
        }
        title = title.equals("") ? accessorDef.getName() : title + " - " + accessorDef.getName();
        return title;
    }

    private Element createPanelGroupLayout(String name, Element parent) {
        if (parent == null) {
            return null;
        }
        Element panelLayoutElem = (Element)this.emptyPanelGroupLayout.cloneNode(false);
        if (this.outputTextElem != null) {
            Element outputElem = (Element)this.outputTextElem.cloneNode(true);
            String value = this.convertTag(name);
            outputElem.setAttribute("value", value);
            outputElem.setAttribute("inlineStyle", STYLE);
            panelLayoutElem.appendChild(outputElem);
        }
        parent.appendChild(panelLayoutElem);
        return panelLayoutElem;
    }

    private String convertTag(String name) {
        StringBuffer nameBuf = new StringBuffer();
        StringBuffer word = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            char nc = '\u0000';
            char nnc = '\u0000';
            if (i + 1 < name.length()) {
                nc = name.charAt(i + 1);
            }
            if (i + 2 < name.length()) {
                nnc = name.charAt(i + 2);
            }
            if (c == '_') continue;
            if (word.length() == 0) {
                word.append(Character.toUpperCase(c));
                continue;
            }
            if (nc == '\u0000' || Character.isUpperCase(c) != Character.isUpperCase(nc) || Character.isLowerCase(c) != Character.isLowerCase(nc) || Character.isUpperCase(c) && Character.isUpperCase(nc) && Character.isLowerCase(nnc)) {
                word.append(c);
                nameBuf.append(word);
                if (nc != '\u0000') {
                    nameBuf.append(' ');
                }
                word.delete(0, word.length());
                continue;
            }
            word.append(c);
        }
        String value = nameBuf.toString();
        return value;
    }

    private void printWidgets(Map widgetMap, String type) {
        Set keySet;
        if (widgetMap == null) {
            System.out.println("Widget map is null!");
        }
        if ((keySet = widgetMap.keySet()) == null) {
            System.out.println("No widget keys found!");
        }
        System.out.println("Available Widgets: " + type);
        System.out.println("-----------------------------------------------");
        for (String key : keySet) {
            System.out.println(key);
        }
    }

    private String getDefinitionType(int defType) {
        if (defType == 0) {
            return "TYPE_DEFINITION";
        }
        if (defType == 10) {
            return "TYPE_NAMED";
        }
        if (defType == 20) {
            return "TYPE_STRUCTURE";
        }
        if (defType == 30) {
            return "TYPE_ATTRIBUTE";
        }
        if (defType == 40) {
            return "TYPE_ACCESSOR";
        }
        if (defType == 50) {
            return "TYPE_DATACONTROL";
        }
        if (defType == 60) {
            return "TYPE_OPERATION";
        }
        if (defType == 70) {
            return "TYPE_PARAMETER";
        }
        if (defType == 80) {
            return "TYPE_VARIABLE";
        }
        if (defType == 90) {
            return "TYPE_DEFINITIONCONTEXT";
        }
        if (defType == 100) {
            return "TYPE_OPERATIONRETURN";
        }
        if (defType == 110) {
            return "TYPE_CRITERIA";
        }
        if (defType == 120) {
            return "TYPE_CRITERIA_ROW";
        }
        if (defType == 130) {
            return "TYPE_CRITERIA_ITEM";
        }
        if (defType == 140) {
            return "TYPE_CRITERIA_OPERATOR";
        }
        return null;
    }

    private static class MyNSResolver
    implements NSResolver {
        private MyNSResolver() {
        }

        public String resolveNamespacePrefix(String pref) {
            if (pref.equals("af")) {
                return "http://xmlns.oracle.com/adf/faces/rich";
            }
            return null;
        }
    }
}

