/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.form;

import java.net.URL;
import java.util.Collection;
import oracle.bpm.casemgmt.ui.cm.editor.CaseEditor;
import oracle.bpm.casemgmt.ui.common.form.FormGenHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;

public class TaskFlowController
implements Controller {
    protected static final String CASE_URL = "caseUrl";
    protected static final int OPEN_CASE_EDITOR = Ide.findCmdID((String)"OPEN_CASE_EDITOR");

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == OPEN_CASE_EDITOR) {
            URL caseUrl = (URL)context.getProperty(CASE_URL);
            String dataObjName = (String)context.getProperty("bpmCaseDataObjName");
            String bpmProjName = (String)context.getProperty("bpmProject");
            if (caseUrl == null) {
                return true;
            }
            Project bpmProject = this.getProject(context, bpmProjName);
            if (bpmProject != null) {
                Ide.setActiveProject((Project)bpmProject);
            }
            EditorManager editorMgr = EditorManager.getEditorManager();
            editorMgr.openDefaultEditorInFrame(caseUrl);
            Editor editor = editorMgr.getCurrentEditor();
            if (editor instanceof CaseEditor) {
                CaseEditor caseEditor = (CaseEditor)editor;
                caseEditor.selectData(dataObjName);
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private Project getProject(Context context, String projName) {
        if (context == null || projName == null) {
            return null;
        }
        Workspace ws = context.getWorkspace();
        Collection projects = ws.projects();
        for (Project curProj : projects) {
            String curProjName = FormGenHelper.getProjectName(curProj);
            if (!projName.equals(curProjName)) continue;
            return curProj;
        }
        return null;
    }
}

