/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.form;

import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import java.text.MessageFormat;
import oracle.adfdt.controller.adfc.source.navigator.AdfcConfigNode;
import oracle.bpm.casemgmt.ui.cm.form.TaskFlowController;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;

public class TaskFlowContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Context jdevCtx = contextMenu.getContext();
        Node ideNode = jdevCtx.getNode();
        if (ideNode instanceof AdfcConfigNode) {
            Context context = contextMenu.getContext();
            URL url = ideNode.getURL();
            try {
                DOMParser parser = new DOMParser();
                parser.parse(url);
                XMLDocument doc = parser.getDocument();
                String caseRelPath = this.getProcessingInstructionValue((Document)doc, "bpmCaseRelPath");
                String caseName = this.getProcessingInstructionValue((Document)doc, "bpmCaseName");
                String caseDataObjName = this.getProcessingInstructionValue((Document)doc, "bpmCaseDataObjName");
                String bpmProjName = this.getProcessingInstructionValue((Document)doc, "bpmProject");
                if (caseRelPath != null && caseDataObjName != null) {
                    Workspace ws = jdevCtx.getWorkspace();
                    String wsDir = ws.getBaseDirectory();
                    String casePath = wsDir + "/" + caseRelPath;
                    URL caseUrl = URLFactory.newFileURL((String)casePath);
                    jdevCtx.setProperty("caseUrl", (Object)caseUrl);
                    jdevCtx.setProperty("bpmCaseName", (Object)caseName);
                    jdevCtx.setProperty("bpmCaseDataObjName", (Object)caseDataObjName);
                    jdevCtx.setProperty("bpmProject", (Object)bpmProjName);
                    String[] args = new String[]{caseDataObjName, caseName};
                    String menuText = CaseUiMsg.CASE_FORM_GO_TO_EDITOR.getString();
                    MessageFormat msgFormat = new MessageFormat(menuText);
                    menuText = msgFormat.format(args);
                    IdeAction action = IdeAction.find((int)TaskFlowController.OPEN_CASE_EDITOR);
                    action.setName(menuText);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)action));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    private String getProcessingInstructionValue(Document doc, String piName) {
        if (piName == null) {
            return null;
        }
        for (org.w3c.dom.Node currentNode = doc.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            ProcessingInstruction pi;
            if (!(currentNode instanceof ProcessingInstruction) || !piName.equals((pi = (ProcessingInstruction)currentNode).getTarget())) continue;
            return pi.getData();
        }
        return null;
    }
}

