/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bpm.casemgmt.model.CommonFactory;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.PropertyBundles;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.AbstractEntityPanel;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.components.FormBuilder;
import oracle.bpm.casemgmt.ui.components.TableHeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.javatools.ui.table.GenericTable;
import org.jetbrains.annotations.Nullable;

class TranslationTabPanel
extends AbstractEntityPanel<Case> {
    private TranslationPanel translationPanel;

    public TranslationTabPanel(UiContainer parent, Case casemgmt) {
        super(parent, casemgmt);
        this.init();
    }

    @Override
    public void modelChanged(Event ... events) {
        this.translationPanel.modelChanged(events);
    }

    public void refresh() {
        this.translationPanel.refresh();
    }

    private void init() {
        Case casemgmt = (Case)this.getEntityModel();
        this.setLayout(FormBuilder.createLayoutWithMargin());
        PropertyBundles propertyBundles = casemgmt.getPropertyBundles();
        this.translationPanel = new TranslationPanel(propertyBundles);
        FormBuilder.addExpandX(this, this.translationPanel.build(this));
    }

    private static class TranslationPanel
    extends TableHeaderPanelBuilder<String>
    implements EntityEvents {
        private final EventFilter FILTER = new EventFilter.Default(){

            protected Entity validInstance() {
                return TranslationPanel.this.propertyBundles;
            }
        };
        private PropertyBundles propertyBundles;

        public TranslationPanel(PropertyBundles propertyBundles) {
            super(CaseUiMsg.TRANSLATION, CaseUiMsg.TRANSLATION_DESCRIPTION);
            this.propertyBundles = propertyBundles;
        }

        @Override
        public ProviderTableModel<String> createTableModel() {
            return new TranslationTableModel(this.propertyBundles);
        }

        public TranslationTableModel getTableModel() {
            return (TranslationTableModel)super.getTableModel();
        }

        @Override
        public void modelChanged(Event ... events) {
            Event[] filteredEvents = this.FILTER.apply(events);
            if (filteredEvents.length > 0) {
                this.refresh();
            }
        }

        @Override
        protected void customizeTable(GenericTable table) {
            table.setAutoCreateColumnsFromModel(true);
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn column0 = columnModel.getColumn(0);
            TranslationPanel.setColumnSize(column0, 200);
            this.refreshRemoveButton();
        }

        @Override
        protected void addAction() {
            Locale locale = this.chooseLocale(UIMsg.ADD_LANGUAGE, this.propertyBundles.getAvailableLocales());
            if (locale != null) {
                PropertyBundle bundle = CommonFactory.createPropertyBundle((Locale)locale);
                this.propertyBundles.put((Object)locale, (Object)bundle);
            }
        }

        @Override
        protected void removeAction(List<String> toRemove) {
            Locale locale;
            List locales = this.propertyBundles.getLocales();
            if (!locales.isEmpty() && (locale = this.chooseLocale(CaseUiMsg.REMOVE_LANGUAGE, locales)) != null && this.propertyBundles.containsKey((Object)locale)) {
                this.propertyBundles.remove((Object)locale);
            }
        }

        @Override
        protected void selectionChanged(int[] selectedRows) {
            this.refreshRemoveButton();
        }

        @Override
        protected int actions() {
            return 5;
        }

        private void refreshRemoveButton() {
            List locales = this.propertyBundles.getLocales();
            this.enableAction(4, !locales.isEmpty());
        }

        @Nullable
        private Locale chooseLocale(Msg title, Collection<Locale> locales) {
            Object[] objects = DialogFactory.showInputDialog(this.getEditor().getOwnerWindow(), null, title, locales.toArray(), null, false, LocaleLabelProvider.INSTANCE);
            return objects.length > 0 ? (Locale)objects[0] : null;
        }

        private void refresh() {
            this.refreshRemoveButton();
            this.getTableModel().populate();
            this.getTableModel().fireTableStructureChanged();
        }

        private static class TranslationTableModel
        extends ProviderTableModel<String> {
            private PropertyBundles propertyBundles;
            private static final int COLUMN_KEY = 0;
            private static final int COLUMN_DEFAULT = 1;

            public TranslationTableModel(PropertyBundles propertyBundles) {
                this.propertyBundles = propertyBundles;
                this.populate();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column >= 1;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                PropertyBundle bundle;
                if (column >= 1 && (bundle = this.getPropertyBundle(column)) != null) {
                    String key = (String)this.getRow(row);
                    bundle.put((Object)key, (Object)((String)value));
                }
            }

            @Override
            public Class getColumnClass(int column) {
                return String.class;
            }

            @Override
            public Object getValueAt(int row, int column) {
                String result;
                String key = (String)this.getRow(row);
                switch (column) {
                    case 0: {
                        result = key;
                        break;
                    }
                    case 1: {
                        result = (String)this.propertyBundles.getDefault().get((Object)key);
                        break;
                    }
                    default: {
                        PropertyBundle bundle = this.getPropertyBundle(column);
                        result = bundle != null ? (String)bundle.get((Object)key) : "";
                    }
                }
                return result;
            }

            @Override
            public int getColumnCount() {
                return 2 + this.propertyBundles.size();
            }

            @Override
            public String getColumnName(int column) {
                String result;
                switch (column) {
                    case 0: {
                        result = CoreMsg.NAME.getString();
                        break;
                    }
                    case 1: {
                        result = CaseUiMsg.DISPLAY_NAME.getString();
                        break;
                    }
                    default: {
                        Locale locale = this.getLocale(column);
                        result = locale != null ? locale.getDisplayName() : "";
                    }
                }
                return result;
            }

            private PropertyBundle getPropertyBundle(int column) {
                Locale locale;
                PropertyBundle result = null;
                if (column == 1) {
                    result = this.propertyBundles.getDefault();
                } else if (column > 1 && (locale = this.getLocale(column)) != null) {
                    result = (PropertyBundle)this.propertyBundles.get((Object)locale);
                }
                return result;
            }

            private Locale getLocale(int column) {
                Locale result = null;
                List<Locale> locales = this.getLocales();
                if (!locales.isEmpty() && column > 1 && locales.size() > column - 2) {
                    result = locales.get(column - 2);
                }
                return result;
            }

            private List<Locale> getLocales() {
                return this.propertyBundles.getLocales();
            }

            private void populate() {
                this.getData().clear();
                PropertyBundle root = this.propertyBundles.getDefault();
                this.getData().addAll(root.keySet());
            }
        }

        private static class LocaleLabelProvider
        extends LabelProvider.Default<Locale> {
            public static final LocaleLabelProvider INSTANCE = new LocaleLabelProvider();

            private LocaleLabelProvider() {
            }

            @Override
            public String getText(Locale locale) {
                return locale.getDisplayName();
            }
        }
    }
}

