/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.casemgmt.ui.cm.editor;

import java.awt.Frame;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.model.EventFilter;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.StakeHolder;
import oracle.bpm.casemgmt.model.cm.StakeHolders;
import oracle.bpm.casemgmt.ui.cm.editor.StakeHolderPanelBuilder;
import oracle.bpm.casemgmt.ui.common.EntityEvents;
import oracle.bpm.casemgmt.ui.components.HeaderPanelBuilder;
import oracle.bpm.casemgmt.ui.components.TranslationService;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.collections.Tuple;
import oracle.bpm.common.model.Entity;
import oracle.bpm.common.model.events.Event;
import oracle.bpm.common.model.events.EventType;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Organization;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.MigLayout;
import oracle.ide.dialogs.WizardLauncher;

class StakeHoldersPanelBuilder
extends HeaderPanelBuilder
implements EntityEvents {
    private Case casemgmt;
    private UiContainer container;
    private Map<StakeHolder, StakeHolderPanelBuilder> mapBuilder = new HashMap<StakeHolder, StakeHolderPanelBuilder>();
    private Organization organization;
    private StakeHolders stakeHolders;
    private final EventFilter FILTER = new EventFilter.Default(){

        protected Entity validInstance() {
            return StakeHoldersPanelBuilder.this.stakeHolders;
        }
    };
    private TranslationService translationService;

    public StakeHoldersPanelBuilder(StakeHolders stakeHolders, Case casemgmt, TranslationService translationService, Organization organization) {
        super(CaseUiMsg.STAKEHOLDERS, CaseUiMsg.STAKEHOLDERS_DESCRIPTION);
        this.stakeHolders = stakeHolders;
        this.casemgmt = casemgmt;
        this.translationService = translationService;
        this.organization = organization;
    }

    @Override
    public void modelChanged(Event ... events) {
        Event[] stakeHolderEvents;
        block4: for (Event event : stakeHolderEvents = this.FILTER.apply(events)) {
            Event childEvent = event.getChildEvent();
            if (childEvent == null) continue;
            EventType type = childEvent.getType();
            switch (type) {
                case ATTR_ADDED: {
                    if (!(childEvent.getNewValue() instanceof StakeHolder)) continue block4;
                    this.addStakeHolderPanel((StakeHolder)childEvent.getNewValue());
                    continue block4;
                }
                case ATTR_REMOVED: {
                    if (!(childEvent.getOldValue() instanceof StakeHolder)) continue block4;
                    this.removeStakeHolderPanel((StakeHolder)childEvent.getOldValue());
                }
            }
        }
        this.updateRemoveAction();
        Collection<StakeHolderPanelBuilder> values = this.mapBuilder.values();
        for (StakeHolderPanelBuilder entityEvents : values) {
            entityEvents.modelChanged(events);
        }
    }

    @Override
    protected void addAction() {
        Tuple<String, String> keyValue = this.translationService.showDialog(this.getEditor().getOwnerWindow(), CaseUiMsg.CREATE_STAKEHOLDER, this.stakeHolders.getDefaultName());
        if (keyValue != null) {
            StakeHolder stakeHolder = CaseFactory.createStakeHolder();
            stakeHolder.setName(keyValue.getFirst());
            this.stakeHolders.add((Object)stakeHolder);
        }
    }

    @Override
    protected void removeAction() {
        List<StakeHolder> selection = SelectStakeHolderDialog.show(this.getEditor().getOwnerWindow(), this.stakeHolders, this.translationService);
        if (!selection.isEmpty()) {
            this.stakeHolders.removeAll(selection);
        }
    }

    @Override
    protected int actions() {
        return 5;
    }

    @Override
    protected UiComponent buildEditor(UiContainer parent) {
        this.container = new Panel(parent);
        this.container.setLayout(new MigLayout("fillx, gapx 8, gapy 6, ins 0"));
        for (StakeHolder stakeHolder : this.stakeHolders) {
            this.addStakeHolderPanel(stakeHolder);
        }
        this.updateRemoveAction();
        return this.container;
    }

    private void updateRemoveAction() {
        this.enableAction(4, !this.stakeHolders.isEmpty());
    }

    private void addStakeHolderPanel(StakeHolder stakeHolder) {
        StakeHolderPanelBuilder builder = new StakeHolderPanelBuilder(stakeHolder, this.casemgmt, this.translationService, this.organization);
        UiComponent editor = builder.build(this.container);
        this.container.add(editor, "growx, pushx, wrap");
        this.mapBuilder.put(stakeHolder, builder);
    }

    private void removeStakeHolderPanel(StakeHolder stakeHolder) {
        StakeHolderPanelBuilder builder = this.mapBuilder.get(stakeHolder);
        this.mapBuilder.remove(builder);
        UiComponent component = builder.getEditor();
        this.container.remove(component);
    }

    private static class SelectStakeHolderDialog
    extends JEWTDialog {
        private SelectStakeHolderPanel stakeHolderPanel;

        private SelectStakeHolderDialog(UiWindow parent, StakeHolders stakeHolders, TranslationService translationService) {
            super((Frame)parent.getNative(), CaseUiMsg.SELECT_STAKEHOLDERS.getString(), 3);
            this.init(stakeHolders, translationService);
        }

        public static List<StakeHolder> show(UiWindow parent, StakeHolders stakeHolders, TranslationService translationService) {
            SelectStakeHolderDialog dialog = new SelectStakeHolderDialog(parent, stakeHolders, translationService);
            boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
            return ok ? dialog.getSelection() : Collections.emptyList();
        }

        private List<StakeHolder> getSelection() {
            return this.stakeHolderPanel.getSelection();
        }

        private void init(StakeHolders stakeHolders, TranslationService translationService) {
            this.stakeHolderPanel = new SelectStakeHolderPanel(UiContainer.NULL, stakeHolders, translationService);
            this.setContent(this.stakeHolderPanel.asSwing());
        }

        private static class SelectStakeHolderPanel
        extends Panel {
            private oracle.bpm.ui.List<StakeHolder> stakeHolderList;

            public SelectStakeHolderPanel(UiContainer parent, StakeHolders stakeHolders, TranslationService translationService) {
                super(parent);
                this.init(stakeHolders, translationService);
            }

            private List<StakeHolder> getSelection() {
                return this.stakeHolderList.getSelectedValues();
            }

            private void init(StakeHolders stakeHolders, final TranslationService translationService) {
                this.setLayout(new MigLayout("fill, gapx 8, gapy 6, ins 0"));
                this.stakeHolderList = oracle.bpm.ui.List.create((UiContainer)this, stakeHolders, ListSelectionMode.MULTIPLE_INTERVAL_SELECTION);
                this.stakeHolderList.setLabelProvider(new LabelProvider.Default<StakeHolder>(){

                    @Override
                    public String getText(StakeHolder element) {
                        String value = translationService.getValue(element.getName());
                        return !Str.isEmpty(value) ? value : "[" + element.getName() + "]";
                    }
                });
                this.stakeHolderList.setSize(400, 300);
                this.add(Label.create((UiContainer)this, CaseUiMsg.SELECT_STAKEHOLDERS_TO_REMOVE), "wrap");
                this.add(this.stakeHolderList, "grow");
            }
        }
    }
}

